/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateContainerResponse;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.ConflictException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.NotFoundException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Bind;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Capability;
import org.testcontainers.shaded.com.github.dockerjava.api.model.ContainerNetwork;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Device;
import org.testcontainers.shaded.com.github.dockerjava.api.model.ExposedPort;
import org.testcontainers.shaded.com.github.dockerjava.api.model.ExposedPorts;
import org.testcontainers.shaded.com.github.dockerjava.api.model.HostConfig;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Link;
import org.testcontainers.shaded.com.github.dockerjava.api.model.LogConfig;
import org.testcontainers.shaded.com.github.dockerjava.api.model.LxcConf;
import org.testcontainers.shaded.com.github.dockerjava.api.model.PortBinding;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Ports;
import org.testcontainers.shaded.com.github.dockerjava.api.model.RestartPolicy;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Ulimit;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Volume;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Volumes;
import org.testcontainers.shaded.com.github.dockerjava.api.model.VolumesFrom;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateContainerCmdImpl
extends AbstrDockerCmd<CreateContainerCmd, CreateContainerResponse>
implements CreateContainerCmd {
    private String name;
    @JsonProperty(value="Hostname")
    private String hostName;
    @JsonProperty(value="Domainname")
    private String domainName;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="AttachStdin")
    private Boolean attachStdin;
    @JsonProperty(value="AttachStdout")
    private Boolean attachStdout;
    @JsonProperty(value="AttachStderr")
    private Boolean attachStderr;
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="Tty")
    private Boolean tty;
    @JsonProperty(value="OpenStdin")
    private Boolean stdinOpen;
    @JsonProperty(value="StdinOnce")
    private Boolean stdInOnce;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Entrypoint")
    private String[] entrypoint;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private Volumes volumes = new Volumes(new Volume[0]);
    @JsonProperty(value="WorkingDir")
    private String workingDir;
    @JsonProperty(value="MacAddress")
    private String macAddress;
    @JsonProperty(value="NetworkDisabled")
    private Boolean networkDisabled;
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts = new ExposedPorts(new ExposedPort[0]);
    @JsonProperty(value="StopSignal")
    private String stopSignal;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig = new HostConfig();
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="NetworkingConfig")
    private NetworkingConfig networkingConfig;
    @JsonIgnore
    private String ipv4Address = null;
    @JsonIgnore
    private String ipv6Address = null;
    @JsonIgnore
    private List<String> aliases = null;

    public CreateContainerCmdImpl(CreateContainerCmd.Exec exec, String image) {
        super(exec);
        Preconditions.checkNotNull(image, "image was not specified");
        this.withImage(image);
    }

    @Override
    public CreateContainerResponse exec() throws NotFoundException, ConflictException {
        ContainerNetwork containerNetwork = null;
        if (this.ipv4Address != null || this.ipv6Address != null) {
            containerNetwork = new ContainerNetwork().withIpamConfig(new ContainerNetwork.Ipam().withIpv4Address(this.ipv4Address).withIpv6Address(this.ipv6Address));
        }
        if (this.hostConfig.isUserDefinedNetwork() && this.hostConfig.getLinks().length > 0) {
            if (containerNetwork == null) {
                containerNetwork = new ContainerNetwork();
            }
            containerNetwork.withLinks(this.hostConfig.getLinks());
        }
        if (this.aliases != null) {
            if (containerNetwork == null) {
                containerNetwork = new ContainerNetwork();
            }
            containerNetwork.withAliases(this.aliases);
        }
        if (containerNetwork != null) {
            this.networkingConfig = new NetworkingConfig().withEndpointsConfig(Collections.singletonMap(this.hostConfig.getNetworkMode(), containerNetwork));
        }
        return (CreateContainerResponse)super.exec();
    }

    @Override
    @JsonIgnore
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @JsonIgnore
    public Bind[] getBinds() {
        return this.hostConfig.getBinds();
    }

    @Override
    @JsonIgnore
    public Integer getBlkioWeight() {
        return this.hostConfig.getBlkioWeight();
    }

    @Override
    @JsonIgnore
    public Capability[] getCapAdd() {
        return this.hostConfig.getCapAdd();
    }

    @Override
    @JsonIgnore
    public Capability[] getCapDrop() {
        return this.hostConfig.getCapDrop();
    }

    @Override
    public String[] getCmd() {
        return this.cmd;
    }

    @Override
    @JsonIgnore
    public Integer getCpuPeriod() {
        return this.hostConfig.getCpuPeriod();
    }

    @Override
    @JsonIgnore
    public String getCpusetCpus() {
        return this.hostConfig.getCpusetCpus();
    }

    @Override
    @JsonIgnore
    public String getCpusetMems() {
        return this.hostConfig.getCpusetMems();
    }

    @Override
    @JsonIgnore
    public Integer getCpuShares() {
        return this.hostConfig.getCpuShares();
    }

    @Override
    @JsonIgnore
    public Device[] getDevices() {
        return this.hostConfig.getDevices();
    }

    @Override
    @JsonIgnore
    public String[] getDns() {
        return this.hostConfig.getDns();
    }

    @Override
    @JsonIgnore
    public String[] getDnsSearch() {
        return this.hostConfig.getDnsSearch();
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public String[] getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public String[] getEnv() {
        return this.env;
    }

    @Override
    @JsonIgnore
    public ExposedPort[] getExposedPorts() {
        return this.exposedPorts.getExposedPorts();
    }

    @Override
    @JsonIgnore
    public String getStopSignal() {
        return this.stopSignal;
    }

    @Override
    @JsonIgnore
    public String[] getExtraHosts() {
        return this.hostConfig.getExtraHosts();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public String getIpv4Address() {
        return this.ipv4Address;
    }

    @Override
    public String getIpv6Address() {
        return this.ipv6Address;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    @JsonIgnore
    public Link[] getLinks() {
        return this.hostConfig.getLinks();
    }

    @Override
    @JsonIgnore
    public LxcConf[] getLxcConf() {
        return this.hostConfig.getLxcConf();
    }

    @Override
    @JsonIgnore
    public LogConfig getLogConfig() {
        return this.hostConfig.getLogConfig();
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    @JsonIgnore
    public Long getMemory() {
        return this.hostConfig.getMemory();
    }

    @Override
    @JsonIgnore
    public Long getMemorySwap() {
        return this.hostConfig.getMemorySwap();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getNetworkMode() {
        return this.hostConfig.getNetworkMode();
    }

    @Override
    @JsonIgnore
    public Ports getPortBindings() {
        return this.hostConfig.getPortBindings();
    }

    @Override
    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    @Override
    @JsonIgnore
    public RestartPolicy getRestartPolicy() {
        return this.hostConfig.getRestartPolicy();
    }

    @Override
    @JsonIgnore
    public Ulimit[] getUlimits() {
        return this.hostConfig.getUlimits();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    @JsonIgnore
    public Volume[] getVolumes() {
        return this.volumes.getVolumes();
    }

    @Override
    @JsonIgnore
    public VolumesFrom[] getVolumesFrom() {
        return this.hostConfig.getVolumesFrom();
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public Boolean isAttachStderr() {
        return this.attachStderr;
    }

    @Override
    public Boolean isAttachStdin() {
        return this.attachStdin;
    }

    @Override
    public Boolean isAttachStdout() {
        return this.attachStdout;
    }

    @Override
    public Boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    @Override
    @JsonIgnore
    public Boolean getOomKillDisable() {
        return this.hostConfig.getOomKillDisable();
    }

    @Override
    @JsonIgnore
    public Boolean getPrivileged() {
        return this.hostConfig.getPrivileged();
    }

    @Override
    @JsonIgnore
    public Boolean getPublishAllPorts() {
        return this.hostConfig.getPublishAllPorts();
    }

    @Override
    @JsonIgnore
    public Boolean getReadonlyRootfs() {
        return this.hostConfig.getReadonlyRootfs();
    }

    @Override
    public Boolean isStdInOnce() {
        return this.stdInOnce;
    }

    @Override
    public Boolean isStdinOpen() {
        return this.stdinOpen;
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    @JsonIgnore
    public String getPidMode() {
        return this.hostConfig.getPidMode();
    }

    @Override
    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    @Override
    public String getCgroupParent() {
        return this.hostConfig.getCgroupParent();
    }

    @Override
    public CreateContainerCmd withAliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    @Override
    public CreateContainerCmd withAliases(List<String> aliases) {
        Preconditions.checkNotNull(aliases, "aliases was not specified");
        this.aliases = aliases;
        return this;
    }

    @Override
    public CreateContainerCmd withAttachStderr(Boolean attachStderr) {
        Preconditions.checkNotNull(attachStderr, "attachStderr was not specified");
        this.attachStderr = attachStderr;
        return this;
    }

    @Override
    public CreateContainerCmd withAttachStdin(Boolean attachStdin) {
        Preconditions.checkNotNull(attachStdin, "attachStdin was not specified");
        this.attachStdin = attachStdin;
        return this;
    }

    @Override
    public CreateContainerCmd withAttachStdout(Boolean attachStdout) {
        Preconditions.checkNotNull(attachStdout, "attachStdout was not specified");
        this.attachStdout = attachStdout;
        return this;
    }

    @Override
    public CreateContainerCmd withBinds(Bind ... binds) {
        Preconditions.checkNotNull(binds, "binds was not specified");
        this.hostConfig.setBinds(binds);
        return this;
    }

    @Override
    public CreateContainerCmd withBinds(List<Bind> binds) {
        Preconditions.checkNotNull(binds, "binds was not specified");
        return this.withBinds(binds.toArray(new Bind[binds.size()]));
    }

    @Override
    public CreateContainerCmd withBlkioWeight(Integer blkioWeight) {
        Preconditions.checkNotNull(blkioWeight, "blkioWeight was not specified");
        this.hostConfig.withBlkioWeight(blkioWeight);
        return this;
    }

    @Override
    public CreateContainerCmd withCapAdd(Capability ... capAdd) {
        Preconditions.checkNotNull(capAdd, "capAdd was not specified");
        this.hostConfig.withCapAdd(capAdd);
        return this;
    }

    @Override
    public CreateContainerCmd withCapAdd(List<Capability> capAdd) {
        Preconditions.checkNotNull(capAdd, "capAdd was not specified");
        return this.withCapAdd(capAdd.toArray(new Capability[capAdd.size()]));
    }

    @Override
    public CreateContainerCmd withCapDrop(Capability ... capDrop) {
        Preconditions.checkNotNull(capDrop, "capDrop was not specified");
        this.hostConfig.withCapDrop(capDrop);
        return this;
    }

    @Override
    public CreateContainerCmd withCapDrop(List<Capability> capDrop) {
        Preconditions.checkNotNull(capDrop, "capDrop was not specified");
        return this.withCapDrop(capDrop.toArray(new Capability[capDrop.size()]));
    }

    @Override
    public CreateContainerCmd withCmd(String ... cmd) {
        Preconditions.checkNotNull(cmd, "cmd was not specified");
        this.cmd = cmd;
        return this;
    }

    @Override
    public CreateContainerCmd withCmd(List<String> cmd) {
        Preconditions.checkNotNull(cmd, "cmd was not specified");
        return this.withCmd(cmd.toArray(new String[cmd.size()]));
    }

    @Override
    public CreateContainerCmd withContainerIDFile(String containerIDFile) {
        Preconditions.checkNotNull(containerIDFile, "no containerIDFile was specified");
        this.hostConfig.withContainerIDFile(containerIDFile);
        return this;
    }

    @Override
    public CreateContainerCmd withCpuPeriod(Integer cpuPeriod) {
        Preconditions.checkNotNull(cpuPeriod, "cpuPeriod was not specified");
        this.hostConfig.withCpuPeriod(cpuPeriod);
        return this;
    }

    @Override
    public CreateContainerCmd withCpusetCpus(String cpusetCpus) {
        Preconditions.checkNotNull(cpusetCpus, "cpusetCpus was not specified");
        this.hostConfig.withCpusetCpus(cpusetCpus);
        return this;
    }

    @Override
    public CreateContainerCmd withCpusetMems(String cpusetMems) {
        Preconditions.checkNotNull(cpusetMems, "cpusetMems was not specified");
        this.hostConfig.withCpusetMems(cpusetMems);
        return this;
    }

    @Override
    public CreateContainerCmd withCpuShares(Integer cpuShares) {
        Preconditions.checkNotNull(cpuShares, "cpuShares was not specified");
        this.hostConfig.withCpuShares(cpuShares);
        return this;
    }

    @Override
    public CreateContainerCmd withDevices(Device ... devices) {
        Preconditions.checkNotNull(devices, "devices was not specified");
        this.hostConfig.withDevices(devices);
        return this;
    }

    @Override
    public CreateContainerCmd withDevices(List<Device> devices) {
        Preconditions.checkNotNull(devices, "devices was not specified");
        return this.withDevices(devices.toArray(new Device[devices.size()]));
    }

    @Override
    public CreateContainerCmd withDns(String ... dns) {
        Preconditions.checkNotNull(dns, "dns was not specified");
        this.hostConfig.withDns(dns);
        return this;
    }

    @Override
    public CreateContainerCmd withDns(List<String> dns) {
        Preconditions.checkNotNull(dns, "dns was not specified");
        return this.withDns(dns.toArray(new String[dns.size()]));
    }

    @Override
    public CreateContainerCmd withDnsSearch(String ... dnsSearch) {
        Preconditions.checkNotNull(dnsSearch, "dnsSearch was not specified");
        this.hostConfig.withDnsSearch(dnsSearch);
        return this;
    }

    @Override
    public CreateContainerCmd withDnsSearch(List<String> dnsSearch) {
        Preconditions.checkNotNull(dnsSearch, "dnsSearch was not specified");
        return this.withDnsSearch(dnsSearch.toArray(new String[0]));
    }

    @Override
    public CreateContainerCmd withDomainName(String domainName) {
        Preconditions.checkNotNull(domainName, "no domainName was specified");
        this.domainName = domainName;
        return this;
    }

    @Override
    public CreateContainerCmd withEntrypoint(String ... entrypoint) {
        Preconditions.checkNotNull(entrypoint, "entrypoint was not specified");
        this.entrypoint = entrypoint;
        return this;
    }

    @Override
    public CreateContainerCmd withEntrypoint(List<String> entrypoint) {
        Preconditions.checkNotNull(entrypoint, "entrypoint was not specified");
        return this.withEntrypoint(entrypoint.toArray(new String[entrypoint.size()]));
    }

    @Override
    public CreateContainerCmd withEnv(String ... env) {
        Preconditions.checkNotNull(env, "env was not specified");
        this.env = env;
        return this;
    }

    @Override
    public CreateContainerCmd withEnv(List<String> env) {
        Preconditions.checkNotNull(env, "env was not specified");
        return this.withEnv(env.toArray(new String[env.size()]));
    }

    @Override
    public CreateContainerCmd withExposedPorts(ExposedPort ... exposedPorts) {
        Preconditions.checkNotNull(exposedPorts, "exposedPorts was not specified");
        this.exposedPorts = new ExposedPorts(exposedPorts);
        return this;
    }

    @Override
    public CreateContainerCmd withStopSignal(String stopSignal) {
        Preconditions.checkNotNull(stopSignal, "stopSignal wasn't specified.");
        this.stopSignal = stopSignal;
        return this;
    }

    @Override
    public CreateContainerCmd withExposedPorts(List<ExposedPort> exposedPorts) {
        Preconditions.checkNotNull(exposedPorts, "exposedPorts was not specified");
        return this.withExposedPorts(exposedPorts.toArray(new ExposedPort[exposedPorts.size()]));
    }

    @Override
    public CreateContainerCmd withExtraHosts(String ... extraHosts) {
        Preconditions.checkNotNull(extraHosts, "extraHosts was not specified");
        this.hostConfig.withExtraHosts(extraHosts);
        return this;
    }

    @Override
    public CreateContainerCmd withExtraHosts(List<String> extraHosts) {
        Preconditions.checkNotNull(extraHosts, "extraHosts was not specified");
        return this.withExtraHosts(extraHosts.toArray(new String[extraHosts.size()]));
    }

    @Override
    public CreateContainerCmd withHostName(String hostName) {
        Preconditions.checkNotNull(this.hostConfig, "no hostName was specified");
        this.hostName = hostName;
        return this;
    }

    @Override
    public CreateContainerCmd withImage(String image) {
        Preconditions.checkNotNull(image, "no image was specified");
        this.image = image;
        return this;
    }

    @Override
    public CreateContainerCmd withIpv4Address(String ipv4Address) {
        Preconditions.checkNotNull(ipv4Address, "no ipv4Address was specified");
        this.ipv4Address = ipv4Address;
        return this;
    }

    @Override
    public CreateContainerCmd withIpv6Address(String ipv6Address) {
        Preconditions.checkNotNull(ipv6Address, "no ipv6Address was specified");
        this.ipv6Address = ipv6Address;
        return this;
    }

    @Override
    public CreateContainerCmd withLabels(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels was not specified");
        this.labels = labels;
        return this;
    }

    @Override
    public CreateContainerCmd withLinks(Link ... links) {
        Preconditions.checkNotNull(links, "links was not specified");
        this.hostConfig.setLinks(links);
        return this;
    }

    @Override
    public CreateContainerCmd withLinks(List<Link> links) {
        Preconditions.checkNotNull(links, "links was not specified");
        return this.withLinks(links.toArray(new Link[links.size()]));
    }

    @Override
    public CreateContainerCmd withLxcConf(LxcConf ... lxcConf) {
        Preconditions.checkNotNull(lxcConf, "lxcConf was not specified");
        this.hostConfig.withLxcConf(lxcConf);
        return this;
    }

    @Override
    public CreateContainerCmd withLxcConf(List<LxcConf> lxcConf) {
        Preconditions.checkNotNull(lxcConf, "lxcConf was not specified");
        return this.withLxcConf(lxcConf.toArray(new LxcConf[0]));
    }

    @Override
    public CreateContainerCmd withLogConfig(LogConfig logConfig) {
        Preconditions.checkNotNull(logConfig, "logConfig was not specified");
        this.hostConfig.withLogConfig(logConfig);
        return this;
    }

    @Override
    public CreateContainerCmd withMacAddress(String macAddress) {
        Preconditions.checkNotNull(macAddress, "macAddress was not specified");
        this.macAddress = macAddress;
        return this;
    }

    @Override
    public CreateContainerCmd withMemory(Long memory) {
        Preconditions.checkNotNull(memory, "memory was not specified");
        this.hostConfig.withMemory(memory);
        return this;
    }

    @Override
    public CreateContainerCmd withMemorySwap(Long memorySwap) {
        Preconditions.checkNotNull(memorySwap, "memorySwap was not specified");
        this.hostConfig.withMemorySwap(memorySwap);
        return this;
    }

    @Override
    public CreateContainerCmd withName(String name) {
        Preconditions.checkNotNull(name, "name was not specified");
        this.name = name;
        return this;
    }

    @Override
    public CreateContainerCmd withNetworkDisabled(Boolean disableNetwork) {
        Preconditions.checkNotNull(disableNetwork, "disableNetwork was not specified");
        this.networkDisabled = disableNetwork;
        return this;
    }

    @Override
    public CreateContainerCmd withNetworkMode(String networkMode) {
        Preconditions.checkNotNull(networkMode, "networkMode was not specified");
        this.hostConfig.withNetworkMode(networkMode);
        return this;
    }

    @Override
    public CreateContainerCmd withOomKillDisable(Boolean oomKillDisable) {
        Preconditions.checkNotNull(oomKillDisable, "oomKillDisable was not specified");
        this.hostConfig.withOomKillDisable(oomKillDisable);
        return this;
    }

    @Override
    public CreateContainerCmd withPortBindings(PortBinding ... portBindings) {
        Preconditions.checkNotNull(portBindings, "portBindings was not specified");
        this.hostConfig.withPortBindings(new Ports(portBindings));
        return this;
    }

    @Override
    public CreateContainerCmd withPortBindings(List<PortBinding> portBindings) {
        Preconditions.checkNotNull(portBindings, "portBindings was not specified");
        return this.withPortBindings(portBindings.toArray(new PortBinding[0]));
    }

    @Override
    public CreateContainerCmd withPortBindings(Ports portBindings) {
        Preconditions.checkNotNull(portBindings, "portBindings was not specified");
        this.hostConfig.withPortBindings(portBindings);
        return this;
    }

    @Override
    public CreateContainerCmd withPortSpecs(String ... portSpecs) {
        Preconditions.checkNotNull(portSpecs, "portSpecs was not specified");
        this.portSpecs = portSpecs;
        return this;
    }

    @Override
    public CreateContainerCmd withPortSpecs(List<String> portSpecs) {
        Preconditions.checkNotNull(portSpecs, "portSpecs was not specified");
        return this.withPortSpecs(portSpecs.toArray(new String[portSpecs.size()]));
    }

    @Override
    public CreateContainerCmd withPrivileged(Boolean privileged) {
        Preconditions.checkNotNull(privileged, "no privileged was specified");
        this.hostConfig.withPrivileged(privileged);
        return this;
    }

    @Override
    public CreateContainerCmd withPublishAllPorts(Boolean publishAllPorts) {
        Preconditions.checkNotNull(publishAllPorts, "no publishAllPorts was specified");
        this.hostConfig.withPublishAllPorts(publishAllPorts);
        return this;
    }

    @Override
    public CreateContainerCmd withReadonlyRootfs(Boolean readonlyRootfs) {
        Preconditions.checkNotNull(readonlyRootfs, "no readonlyRootfs was specified");
        this.hostConfig.withReadonlyRootfs(readonlyRootfs);
        return this;
    }

    @Override
    public CreateContainerCmd withRestartPolicy(RestartPolicy restartPolicy) {
        Preconditions.checkNotNull(restartPolicy, "restartPolicy was not specified");
        this.hostConfig.withRestartPolicy(restartPolicy);
        return this;
    }

    @Override
    public CreateContainerCmd withStdInOnce(Boolean stdInOnce) {
        Preconditions.checkNotNull(stdInOnce, "no stdInOnce was specified");
        this.stdInOnce = stdInOnce;
        return this;
    }

    @Override
    public CreateContainerCmd withStdinOpen(Boolean stdinOpen) {
        Preconditions.checkNotNull(stdinOpen, "no stdinOpen was specified");
        this.stdinOpen = stdinOpen;
        return this;
    }

    @Override
    public CreateContainerCmd withTty(Boolean tty) {
        Preconditions.checkNotNull(tty, "no tty was specified");
        this.tty = tty;
        return this;
    }

    @Override
    public CreateContainerCmd withUlimits(Ulimit ... ulimits) {
        Preconditions.checkNotNull(ulimits, "no ulimits was specified");
        this.hostConfig.withUlimits(ulimits);
        return this;
    }

    @Override
    public CreateContainerCmd withUlimits(List<Ulimit> ulimits) {
        Preconditions.checkNotNull(ulimits, "no ulimits was specified");
        return this.withUlimits(ulimits.toArray(new Ulimit[ulimits.size()]));
    }

    @Override
    public CreateContainerCmd withUser(String user) {
        Preconditions.checkNotNull(user, "user was not specified");
        this.user = user;
        return this;
    }

    @Override
    public CreateContainerCmd withVolumes(Volume ... volumes) {
        Preconditions.checkNotNull(volumes, "volumes was not specified");
        this.volumes = new Volumes(volumes);
        return this;
    }

    @Override
    public CreateContainerCmd withVolumes(List<Volume> volumes) {
        Preconditions.checkNotNull(volumes, "volumes was not specified");
        return this.withVolumes(volumes.toArray(new Volume[volumes.size()]));
    }

    @Override
    public CreateContainerCmd withVolumesFrom(VolumesFrom ... volumesFrom) {
        Preconditions.checkNotNull(volumesFrom, "volumesFrom was not specified");
        this.hostConfig.withVolumesFrom(volumesFrom);
        return this;
    }

    @Override
    public CreateContainerCmd withVolumesFrom(List<VolumesFrom> volumesFrom) {
        Preconditions.checkNotNull(volumesFrom, "volumesFrom was not specified");
        return this.withVolumesFrom(volumesFrom.toArray(new VolumesFrom[volumesFrom.size()]));
    }

    @Override
    public CreateContainerCmd withWorkingDir(String workingDir) {
        Preconditions.checkNotNull(workingDir, "workingDir was not specified");
        this.workingDir = workingDir;
        return this;
    }

    @Override
    public CreateContainerCmd withCgroupParent(String cgroupParent) {
        Preconditions.checkNotNull(cgroupParent, "cgroupParent was not specified");
        this.hostConfig.withCgroupParent(cgroupParent);
        return this;
    }

    @Override
    public CreateContainerCmd withPidMode(String pidMode) {
        Preconditions.checkNotNull(pidMode, "pidMode was not specified");
        this.hostConfig.withPidMode(pidMode);
        return this;
    }

    @Override
    public CreateContainerCmd withHostConfig(HostConfig hostConfig) {
        this.hostConfig = hostConfig;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public static class NetworkingConfig {
        @JsonProperty(value="EndpointsConfig")
        public Map<String, ContainerNetwork> endpointsConfig;

        public Map<String, ContainerNetwork> getEndpointsConfig() {
            return this.endpointsConfig;
        }

        public NetworkingConfig withEndpointsConfig(Map<String, ContainerNetwork> endpointsConfig) {
            this.endpointsConfig = endpointsConfig;
            return this;
        }
    }
}

