/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonParser;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonToken;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JavaType;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

@JacksonStdImpl
public class MapEntryDeserializer
extends ContainerDeserializerBase<Map.Entry<Object, Object>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _type;
    protected final KeyDeserializer _keyDeserializer;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public MapEntryDeserializer(JavaType type, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(type);
        if (type.containedTypeCount() != 2) {
            throw new IllegalArgumentException("Missing generic type information for " + type);
        }
        this._type = type;
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    protected MapEntryDeserializer(MapEntryDeserializer src) {
        super(src._type);
        this._type = src._type;
        this._keyDeserializer = src._keyDeserializer;
        this._valueDeserializer = src._valueDeserializer;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
    }

    protected MapEntryDeserializer(MapEntryDeserializer src, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(src._type);
        this._type = src._type;
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    protected MapEntryDeserializer withResolved(KeyDeserializer keyDeser, TypeDeserializer valueTypeDeser, JsonDeserializer<?> valueDeser) {
        if (this._keyDeserializer == keyDeser && this._valueDeserializer == valueDeser && this._valueTypeDeserializer == valueTypeDeser) {
            return this;
        }
        return new MapEntryDeserializer(this, keyDeser, valueDeser, valueTypeDeser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this._keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this._type.containedType(0), property);
        } else if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)((Object)kd)).createContextual(ctxt, property);
        }
        JsonDeserializer<Object> vd = this._valueDeserializer;
        vd = this.findConvertingContentDeserializer(ctxt, property, vd);
        JavaType contentType = this._type.containedType(1);
        vd = vd == null ? ctxt.findContextualValueDeserializer(contentType, property) : ctxt.handleSecondaryContextualization(vd, property, contentType);
        TypeDeserializer vtd = this._valueTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property);
        }
        return this.withResolved(kd, vtd, vd);
    }

    @Override
    public JavaType getContentType() {
        return this._type.containedType(1);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME && t != JsonToken.END_OBJECT) {
            return (Map.Entry)this._deserializeFromEmpty(jp, ctxt);
        }
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        if (t != JsonToken.FIELD_NAME) {
            if (t == JsonToken.END_OBJECT) {
                throw ctxt.mappingException("Can not deserialize a Map.Entry out of empty JSON Object");
            }
            throw ctxt.mappingException(this.handledType(), t);
        }
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        String keyStr = jp.getCurrentName();
        Object key = keyDes.deserializeKey(keyStr, ctxt);
        Object value = null;
        t = jp.nextToken();
        try {
            value = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
        }
        catch (Exception e) {
            this.wrapAndThrow(e, Map.Entry.class, keyStr);
        }
        t = jp.nextToken();
        if (t != JsonToken.END_OBJECT) {
            if (t == JsonToken.FIELD_NAME) {
                throw ctxt.mappingException("Problem binding JSON into Map.Entry: more than one entry in JSON (second field: '" + jp.getCurrentName() + "')");
            }
            throw ctxt.mappingException("Problem binding JSON into Map.Entry: unexpected content after JSON Object entry: " + (Object)((Object)t));
        }
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }

    @Override
    public Map.Entry<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt, Map.Entry<Object, Object> result) throws IOException {
        throw new IllegalStateException("Can not update Map.Entry values");
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    @Override
    public JavaType getValueType() {
        return this._type;
    }
}

