/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang.SystemUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.profiler.Profiler;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.startupcheck.IsRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.MinimumDurationRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.wait.Wait;
import org.testcontainers.containers.wait.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateContainerCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ExecCreateCmdResponse;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Bind;
import org.testcontainers.shaded.com.github.dockerjava.api.model.ExposedPort;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Info;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Link;
import org.testcontainers.shaded.com.github.dockerjava.api.model.PortBinding;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Ports;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Volume;
import org.testcontainers.shaded.com.github.dockerjava.api.model.VolumesFrom;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.utility.CommandLine;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.DockerMachineClient;
import org.testcontainers.utility.LogUtils;
import org.testcontainers.utility.PathUtils;
import org.testcontainers.utility.ResourceReaper;
import org.testcontainers.utility.TestEnvironment;

public class GenericContainer<SELF extends GenericContainer<SELF>>
extends FailureDetectingExternalResource
implements Container<SELF> {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int CONTAINER_RUNNING_TIMEOUT_SEC = 30;
    @NonNull
    private List<Integer> exposedPorts = new ArrayList<Integer>();
    @NonNull
    private List<String> portBindings = new ArrayList<String>();
    @NonNull
    private List<String> extraHosts = new ArrayList<String>();
    @NonNull
    private String networkMode;
    @NonNull
    private Future<String> image;
    @NonNull
    private List<String> env = new ArrayList<String>();
    @NonNull
    private String[] commandParts = new String[0];
    @NonNull
    private List<Bind> binds = new ArrayList<Bind>();
    @NonNull
    private boolean privilegedMode;
    @NonNull
    private List<VolumesFrom> volumesFroms = new ArrayList<VolumesFrom>();
    @NonNull
    private Map<String, LinkableContainer> linkedContainers = new HashMap<String, LinkableContainer>();
    private StartupCheckStrategy startupCheckStrategy = new IsRunningStartupCheckStrategy();
    private int startupAttempts = 1;
    @Nullable
    private String workingDirectory = null;
    protected DockerClient dockerClient = DockerClientFactory.instance().client();
    protected Info dockerDaemonInfo = null;
    protected String containerId;
    protected String containerName;
    @NonNull
    protected WaitStrategy waitStrategy = Wait.defaultWaitStrategy();
    @Nullable
    private InspectContainerResponse containerInfo;
    private List<Consumer<OutputFrame>> logConsumers = new ArrayList<Consumer<OutputFrame>>();
    private static final Set<String> AVAILABLE_IMAGE_NAME_CACHE = new HashSet<String>();
    private static final RateLimiter DOCKER_CLIENT_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(1, TimeUnit.SECONDS).withConstantThroughput().build();

    public GenericContainer() {
        this("alpine:3.2");
    }

    public GenericContainer(@NonNull String dockerImageName) {
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName");
        }
        this.setDockerImageName(dockerImageName);
    }

    public GenericContainer(@NonNull Future<String> image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        this.image = image;
    }

    public void start() {
        Profiler profiler = new Profiler("Container startup");
        profiler.setLogger(this.logger());
        try {
            profiler.start("Prepare container configuration and host configuration");
            this.configure();
            this.logger().debug("Starting container: {}", (Object)this.getDockerImageName());
            this.logger().debug("Trying to start container: {}", (Object)this.image.get());
            AtomicInteger attempt = new AtomicInteger(0);
            Unreliables.retryUntilSuccess(this.startupAttempts, () -> {
                this.logger().debug("Trying to start container: {} (attempt {}/{})", this.image.get(), attempt.incrementAndGet(), this.startupAttempts);
                this.tryStart(profiler.startNested("Container startup attempt"));
                return true;
            });
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Container startup failed", e);
        }
        finally {
            profiler.stop().log();
        }
    }

    private void tryStart(Profiler profiler) {
        try {
            String dockerImageName = this.image.get();
            this.logger().debug("Starting container: {}", (Object)dockerImageName);
            this.logger().info("Creating container for image: {}", (Object)dockerImageName);
            profiler.start("Create container");
            CreateContainerCmd createCommand = this.dockerClient.createContainerCmd(dockerImageName);
            this.applyConfiguration(createCommand);
            this.containerId = createCommand.exec().getId();
            ResourceReaper.instance().registerContainerForCleanup(this.containerId, dockerImageName);
            this.logger().info("Starting container with ID: {}", (Object)this.containerId);
            profiler.start("Start container");
            this.dockerClient.startContainerCmd(this.containerId).exec();
            this.logConsumers.forEach(this::followOutput);
            this.logger().info("Container {} is starting: {}", (Object)dockerImageName, (Object)this.containerId);
            profiler.start("Inspecting container");
            this.containerInfo = this.dockerClient.inspectContainerCmd(this.containerId).exec();
            this.containerName = this.containerInfo.getName();
            profiler.start("Call containerIsStarting on subclasses");
            this.containerIsStarting(this.containerInfo);
            profiler.start("Wait until container has started properly, or there's evidence it failed to start.");
            if (!this.startupCheckStrategy.waitUntilStartupSuccessful(this.dockerClient, this.containerId)) {
                throw new IllegalStateException("Container did not start correctly.");
            }
            profiler.start("Wait until container started properly");
            this.waitUntilContainerStarted();
            this.logger().info("Container {} started", (Object)dockerImageName);
            this.containerIsStarted(this.containerInfo);
        }
        catch (Exception e) {
            this.logger().error("Could not start container", e);
            this.logger().error("Container log output (if any) will follow:");
            FrameConsumerResultCallback resultCallback = new FrameConsumerResultCallback();
            resultCallback.addConsumer(OutputFrame.OutputType.STDOUT, new Slf4jLogConsumer(this.logger()));
            resultCallback.addConsumer(OutputFrame.OutputType.STDERR, new Slf4jLogConsumer(this.logger()));
            this.dockerClient.logContainerCmd(this.containerId).withStdOut(true).withStdErr(true).exec(resultCallback);
            try {
                resultCallback.getCompletionLatch().await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new ContainerLaunchException("Could not create/start container", e);
        }
        finally {
            profiler.stop();
        }
    }

    public void stop() {
        String imageName;
        if (this.containerId == null) {
            return;
        }
        try {
            imageName = this.image.get();
        }
        catch (Exception e) {
            imageName = "<unknown>";
        }
        ResourceReaper.instance().stopAndRemoveContainer(this.containerId, imageName);
    }

    protected Logger logger() {
        return DockerLoggerFactory.getLogger(this.getDockerImageName());
    }

    protected Path createVolumeDirectory(boolean temporary) {
        Path directory = new File(".tmp-volume-" + System.currentTimeMillis()).toPath();
        PathUtils.mkdirp(directory);
        if (temporary) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> PathUtils.recursiveDeleteDir(directory)));
        }
        return directory;
    }

    protected void configure() {
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
    }

    protected Integer getLivenessCheckPort() {
        if (this.exposedPorts.size() > 0) {
            return this.getMappedPort(this.exposedPorts.get(0));
        }
        if (this.portBindings.size() > 0) {
            return Integer.valueOf(PortBinding.parse(this.portBindings.get(0)).getBinding().getHostPortSpec());
        }
        return null;
    }

    private void applyConfiguration(CreateContainerCmd createCommand) {
        Optional networkForLinks;
        ExposedPort[] portArray = (ExposedPort[])this.exposedPorts.stream().map(ExposedPort::new).toArray(ExposedPort[]::new);
        createCommand.withExposedPorts(portArray);
        PortBinding[] portBindingArray = (PortBinding[])this.portBindings.stream().map(PortBinding::parse).toArray(PortBinding[]::new);
        createCommand.withPortBindings(portBindingArray);
        if (this.commandParts != null) {
            createCommand.withCmd(this.commandParts);
        }
        String[] envArray = (String[])this.env.stream().toArray(String[]::new);
        createCommand.withEnv(envArray);
        Bind[] bindsArray = (Bind[])this.binds.stream().toArray(Bind[]::new);
        createCommand.withBinds(bindsArray);
        VolumesFrom[] volumesFromsArray = (VolumesFrom[])this.volumesFroms.stream().toArray(VolumesFrom[]::new);
        createCommand.withVolumesFrom(volumesFromsArray);
        HashSet allLinks = new HashSet();
        HashSet allLinkedContainerNetworks = new HashSet();
        for (Map.Entry<String, LinkableContainer> linkEntries : this.linkedContainers.entrySet()) {
            String alias = linkEntries.getKey();
            LinkableContainer linkableContainer = linkEntries.getValue();
            Set links = ((List)this.dockerClient.listContainersCmd().exec()).stream().filter(container -> container.getNames()[0].endsWith(linkableContainer.getContainerName())).map(container -> new Link(container.getNames()[0], alias)).collect(Collectors.toSet());
            allLinks.addAll(links);
            boolean linkableContainerIsRunning = ((List)this.dockerClient.listContainersCmd().exec()).stream().filter(container -> container.getNames()[0].endsWith(linkableContainer.getContainerName())).map(org.testcontainers.shaded.com.github.dockerjava.api.model.Container::getId).map(id -> this.dockerClient.inspectContainerCmd((String)id).exec()).anyMatch(linkableContainerInspectResponse -> linkableContainerInspectResponse.getState().getRunning());
            if (!linkableContainerIsRunning) {
                throw new ContainerLaunchException("Aborting attempt to link to container " + linkableContainer.getContainerName() + " as it is not running");
            }
            Set linkedContainerNetworks = ((List)this.dockerClient.listContainersCmd().exec()).stream().filter(container -> container.getNames()[0].endsWith(linkableContainer.getContainerName())).filter(container -> container.getNetworkSettings() != null && container.getNetworkSettings().getNetworks() != null).flatMap(container -> container.getNetworkSettings().getNetworks().keySet().stream()).distinct().collect(Collectors.toSet());
            allLinkedContainerNetworks.addAll(linkedContainerNetworks);
        }
        createCommand.withLinks(allLinks.toArray(new Link[allLinks.size()]));
        allLinkedContainerNetworks.remove("bridge");
        if (allLinkedContainerNetworks.size() > 1) {
            this.logger().warn("Container needs to be on more than one custom network to link to other containers - this is not currently supported. Required networks are: {}", (Object)allLinkedContainerNetworks);
        }
        if ((networkForLinks = allLinkedContainerNetworks.stream().findFirst()).isPresent()) {
            this.logger().debug("Associating container with network: {}", networkForLinks.get());
            createCommand.withNetworkMode((String)networkForLinks.get());
        }
        createCommand.withPublishAllPorts(true);
        String[] extraHostsArray = (String[])this.extraHosts.stream().toArray(String[]::new);
        createCommand.withExtraHosts(extraHostsArray);
        if (this.networkMode != null) {
            createCommand.withNetworkMode(this.networkMode);
        }
        if (this.workingDirectory != null) {
            createCommand.withWorkingDir(this.workingDirectory);
        }
        if (this.privilegedMode) {
            createCommand.withPrivileged(this.privilegedMode);
        }
    }

    @Override
    public SELF waitingFor(@NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy");
        }
        this.waitStrategy = waitStrategy;
        return (SELF)((GenericContainer)this.self());
    }

    protected WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady(this);
    }

    @Override
    public void setCommand(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.commandParts = command.split(" ");
    }

    @Override
    public void setCommand(String ... commandParts) {
        if (commandParts == null) {
            throw new NullPointerException("commandParts");
        }
        this.commandParts = commandParts;
    }

    @Override
    public void addEnv(String key, String value) {
        this.env.add(key + "=" + value);
    }

    @Override
    public void addFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        if (hostPath.contains(".jar!")) {
            hostPath = PathUtils.extractClassPathResourceToTempLocation(hostPath);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            hostPath = PathUtils.createMinGWPath(hostPath);
        }
        this.binds.add(new Bind(hostPath, new Volume(containerPath), mode.accessMode));
    }

    @Override
    public SELF withFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        this.addFileSystemBind(hostPath, containerPath, mode);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withVolumesFrom(Container container, BindMode mode) {
        this.addVolumesFrom(container, mode);
        return (SELF)((GenericContainer)this.self());
    }

    private void addVolumesFrom(Container container, BindMode mode) {
        this.volumesFroms.add(new VolumesFrom(container.getContainerName(), mode.accessMode));
    }

    @Override
    public void addLink(LinkableContainer otherContainer, String alias) {
        this.linkedContainers.put(alias, otherContainer);
    }

    @Override
    public void addExposedPort(Integer port) {
        this.exposedPorts.add(port);
    }

    @Override
    public void addExposedPorts(int ... ports) {
        for (int port : ports) {
            this.exposedPorts.add(port);
        }
    }

    @Override
    protected void starting(Description description) {
        this.start();
    }

    @Override
    protected void finished(Description description) {
        this.stop();
    }

    @Override
    public SELF withExposedPorts(Integer ... ports) {
        this.setExposedPorts(Arrays.asList(ports));
        return (SELF)((GenericContainer)this.self());
    }

    protected void addFixedExposedPort(int hostPort, int containerPort) {
        this.portBindings.add(String.format("%d:%d", hostPort, containerPort));
    }

    @Override
    public SELF withEnv(String key, String value) {
        this.addEnv(key, value);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withEnv(Map<String, String> env) {
        env.forEach(this::addEnv);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCommand(String cmd) {
        this.setCommand(cmd);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCommand(String ... commandParts) {
        this.setCommand(commandParts);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withExtraHost(String hostname, String ipAddress) {
        this.extraHosts.add(String.format("%s:%s", hostname, ipAddress));
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode) {
        URL resource = GenericContainer.class.getClassLoader().getResource(resourcePath);
        if (resource == null) {
            throw new IllegalArgumentException("Could not find classpath resource at provided path: " + resourcePath);
        }
        String resourceFilePath = resource.getFile();
        this.addFileSystemBind(resourceFilePath, containerPath, mode);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withStartupTimeout(Duration startupTimeout) {
        this.getWaitStrategy().withStartupTimeout(startupTimeout);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withPrivilegedMode(boolean mode) {
        this.privilegedMode = mode;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public String getContainerIpAddress() {
        return DockerClientFactory.instance().dockerHostIpAddress();
    }

    @Override
    public SELF withMinimumRunningDuration(Duration minimumRunningDuration) {
        this.startupCheckStrategy = new MinimumDurationRunningStartupCheckStrategy(minimumRunningDuration);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withStartupCheckStrategy(StartupCheckStrategy strategy) {
        this.startupCheckStrategy = strategy;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withWorkingDirectory(String workDir) {
        this.setWorkingDirectory(workDir);
        return (SELF)((GenericContainer)this.self());
    }

    @Deprecated
    public String getIpAddress() {
        return this.getContainerIpAddress();
    }

    @Override
    public Boolean isRunning() {
        try {
            return this.dockerClient.inspectContainerCmd(this.containerId).exec().getState().getRunning();
        }
        catch (DockerException e) {
            return false;
        }
    }

    @Override
    public Integer getMappedPort(int originalPort) {
        Preconditions.checkState(this.containerId != null, "Mapped port can only be obtained after the container is started");
        Ports.Binding[] binding = new Ports.Binding[]{};
        if (this.containerInfo != null) {
            binding = this.containerInfo.getNetworkSettings().getPorts().getBindings().get(new ExposedPort(originalPort));
        }
        if (binding != null && binding.length > 0 && binding[0] != null) {
            return Integer.valueOf(binding[0].getHostPortSpec());
        }
        throw new IllegalArgumentException("Requested port (" + originalPort + ") is not mapped");
    }

    @Override
    public void setDockerImageName(@NonNull String dockerImageName) {
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName");
        }
        this.image = new RemoteDockerImage(dockerImageName);
        this.getDockerImageName();
    }

    @Override
    @NonNull
    public String getDockerImageName() {
        try {
            return this.image.get();
        }
        catch (Exception e) {
            throw new ContainerFetchException("Can't get Docker image name from " + this.image, e);
        }
    }

    @Override
    public String getTestHostIpAddress() {
        if (DockerMachineClient.instance().isInstalled()) {
            try {
                Optional<String> defaultMachine = DockerMachineClient.instance().getDefaultMachine();
                if (!defaultMachine.isPresent()) {
                    throw new IllegalStateException("Could not find a default docker-machine instance");
                }
                String sshConnectionString = CommandLine.runShellCommand("docker-machine", "ssh", defaultMachine.get(), "echo $SSH_CONNECTION").trim();
                if (Strings.isNullOrEmpty(sshConnectionString)) {
                    throw new IllegalStateException("Could not obtain SSH_CONNECTION environment variable for docker machine " + defaultMachine.get());
                }
                String[] sshConnectionParts = sshConnectionString.split("\\s");
                if (sshConnectionParts.length != 4) {
                    throw new IllegalStateException("Unexpected pattern for SSH_CONNECTION for docker machine - expected 'IP PORT IP PORT' pattern but found '" + sshConnectionString + "'");
                }
                return sshConnectionParts[0];
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("getTestHostIpAddress() is only implemented for docker-machine right now");
    }

    @Override
    public void followOutput(Consumer<OutputFrame> consumer) {
        this.followOutput(consumer, OutputFrame.OutputType.STDOUT, OutputFrame.OutputType.STDERR);
    }

    @Override
    public void followOutput(Consumer<OutputFrame> consumer, OutputFrame.OutputType ... types) {
        LogUtils.followOutput(this.dockerClient, this.containerId, consumer, types);
    }

    @Override
    public SELF withLogConsumer(Consumer<OutputFrame> consumer) {
        this.logConsumers.add(consumer);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public synchronized Info fetchDockerDaemonInfo() throws IOException {
        if (this.dockerDaemonInfo == null) {
            this.dockerDaemonInfo = (Info)this.dockerClient.infoCmd().exec();
        }
        return this.dockerDaemonInfo;
    }

    @Override
    public Container.ExecResult execInContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.execInContainer(UTF8, command);
    }

    @Override
    public Container.ExecResult execInContainer(Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        if (!TestEnvironment.dockerExecutionDriverSupportsExec()) {
            throw new UnsupportedOperationException("Your docker daemon is running the \"lxc\" driver, which doesn't support \"docker exec\".");
        }
        if (!this.isRunning().booleanValue()) {
            throw new IllegalStateException("Container is not running so exec cannot be run");
        }
        this.dockerClient.execCreateCmd(this.containerId).withCmd(command);
        this.logger().debug("Running \"exec\" command: " + String.join((CharSequence)" ", command));
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(this.containerId).withAttachStdout(true).withAttachStderr(true).withCmd(command).exec();
        ToStringConsumer stdoutConsumer = new ToStringConsumer();
        ToStringConsumer stderrConsumer = new ToStringConsumer();
        FrameConsumerResultCallback callback = new FrameConsumerResultCallback();
        callback.addConsumer(OutputFrame.OutputType.STDOUT, stdoutConsumer);
        callback.addConsumer(OutputFrame.OutputType.STDERR, stderrConsumer);
        this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec(callback).awaitCompletion();
        Container.ExecResult result = new Container.ExecResult(stdoutConsumer.toString(outputCharset), stderrConsumer.toString(outputCharset));
        this.logger().trace("stdout: " + result.getStdout());
        this.logger().trace("stderr: " + result.getStderr());
        return result;
    }

    public void withStartupAttempts(int attempts) {
        this.startupAttempts = attempts;
    }

    @Override
    @NonNull
    public List<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    @NonNull
    public List<String> getPortBindings() {
        return this.portBindings;
    }

    @Override
    @NonNull
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    @NonNull
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Override
    @NonNull
    public Future<String> getImage() {
        return this.image;
    }

    @Override
    @NonNull
    public List<String> getEnv() {
        return this.env;
    }

    @Override
    @NonNull
    public String[] getCommandParts() {
        return this.commandParts;
    }

    @Override
    @NonNull
    public List<Bind> getBinds() {
        return this.binds;
    }

    @NonNull
    public boolean isPrivilegedMode() {
        return this.privilegedMode;
    }

    @NonNull
    public List<VolumesFrom> getVolumesFroms() {
        return this.volumesFroms;
    }

    @Override
    @NonNull
    public Map<String, LinkableContainer> getLinkedContainers() {
        return this.linkedContainers;
    }

    public StartupCheckStrategy getStartupCheckStrategy() {
        return this.startupCheckStrategy;
    }

    public int getStartupAttempts() {
        return this.startupAttempts;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    @Override
    public Info getDockerDaemonInfo() {
        return this.dockerDaemonInfo;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    @Nullable
    public InspectContainerResponse getContainerInfo() {
        return this.containerInfo;
    }

    public List<Consumer<OutputFrame>> getLogConsumers() {
        return this.logConsumers;
    }

    @Override
    public void setExposedPorts(@NonNull List<Integer> exposedPorts) {
        if (exposedPorts == null) {
            throw new NullPointerException("exposedPorts");
        }
        this.exposedPorts = exposedPorts;
    }

    @Override
    public void setPortBindings(@NonNull List<String> portBindings) {
        if (portBindings == null) {
            throw new NullPointerException("portBindings");
        }
        this.portBindings = portBindings;
    }

    @Override
    public void setExtraHosts(@NonNull List<String> extraHosts) {
        if (extraHosts == null) {
            throw new NullPointerException("extraHosts");
        }
        this.extraHosts = extraHosts;
    }

    public void setNetworkMode(@NonNull String networkMode) {
        if (networkMode == null) {
            throw new NullPointerException("networkMode");
        }
        this.networkMode = networkMode;
    }

    @Override
    public void setImage(@NonNull Future<String> image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        this.image = image;
    }

    @Override
    public void setEnv(@NonNull List<String> env) {
        if (env == null) {
            throw new NullPointerException("env");
        }
        this.env = env;
    }

    @Override
    public void setCommandParts(@NonNull String[] commandParts) {
        if (commandParts == null) {
            throw new NullPointerException("commandParts");
        }
        this.commandParts = commandParts;
    }

    @Override
    public void setBinds(@NonNull List<Bind> binds) {
        if (binds == null) {
            throw new NullPointerException("binds");
        }
        this.binds = binds;
    }

    public void setPrivilegedMode(@NonNull boolean privilegedMode) {
        this.privilegedMode = privilegedMode;
    }

    public void setVolumesFroms(@NonNull List<VolumesFrom> volumesFroms) {
        if (volumesFroms == null) {
            throw new NullPointerException("volumesFroms");
        }
        this.volumesFroms = volumesFroms;
    }

    @Override
    public void setLinkedContainers(@NonNull Map<String, LinkableContainer> linkedContainers) {
        if (linkedContainers == null) {
            throw new NullPointerException("linkedContainers");
        }
        this.linkedContainers = linkedContainers;
    }

    public void setStartupCheckStrategy(StartupCheckStrategy startupCheckStrategy) {
        this.startupCheckStrategy = startupCheckStrategy;
    }

    public void setStartupAttempts(int startupAttempts) {
        this.startupAttempts = startupAttempts;
    }

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }

    @Override
    public void setDockerDaemonInfo(Info dockerDaemonInfo) {
        this.dockerDaemonInfo = dockerDaemonInfo;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    @Override
    public void setWaitStrategy(@NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy");
        }
        this.waitStrategy = waitStrategy;
    }

    @Override
    public void setContainerInfo(@Nullable InspectContainerResponse containerInfo) {
        this.containerInfo = containerInfo;
    }

    public void setLogConsumers(List<Consumer<OutputFrame>> logConsumers) {
        this.logConsumers = logConsumers;
    }

    public String toString() {
        return "GenericContainer(exposedPorts=" + this.getExposedPorts() + ", portBindings=" + this.getPortBindings() + ", extraHosts=" + this.getExtraHosts() + ", networkMode=" + this.getNetworkMode() + ", image=" + this.getImage() + ", env=" + this.getEnv() + ", commandParts=" + Arrays.deepToString(this.getCommandParts()) + ", binds=" + this.getBinds() + ", privilegedMode=" + this.isPrivilegedMode() + ", volumesFroms=" + this.getVolumesFroms() + ", linkedContainers=" + this.getLinkedContainers() + ", startupCheckStrategy=" + this.getStartupCheckStrategy() + ", startupAttempts=" + this.getStartupAttempts() + ", workingDirectory=" + this.getWorkingDirectory() + ", dockerClient=" + this.getDockerClient() + ", dockerDaemonInfo=" + this.getDockerDaemonInfo() + ", containerId=" + this.getContainerId() + ", containerName=" + this.getContainerName() + ", waitStrategy=" + this.getWaitStrategy() + ", containerInfo=" + this.getContainerInfo() + ", logConsumers=" + this.getLogConsumers() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericContainer)) {
            return false;
        }
        GenericContainer other = (GenericContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Integer> this$exposedPorts = this.getExposedPorts();
        List<Integer> other$exposedPorts = other.getExposedPorts();
        if (this$exposedPorts == null ? other$exposedPorts != null : !((Object)this$exposedPorts).equals(other$exposedPorts)) {
            return false;
        }
        List<String> this$portBindings = this.getPortBindings();
        List<String> other$portBindings = other.getPortBindings();
        if (this$portBindings == null ? other$portBindings != null : !((Object)this$portBindings).equals(other$portBindings)) {
            return false;
        }
        List<String> this$extraHosts = this.getExtraHosts();
        List<String> other$extraHosts = other.getExtraHosts();
        if (this$extraHosts == null ? other$extraHosts != null : !((Object)this$extraHosts).equals(other$extraHosts)) {
            return false;
        }
        String this$networkMode = this.getNetworkMode();
        String other$networkMode = other.getNetworkMode();
        if (this$networkMode == null ? other$networkMode != null : !this$networkMode.equals(other$networkMode)) {
            return false;
        }
        Future<String> this$image = this.getImage();
        Future<String> other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List<String> this$env = this.getEnv();
        List<String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCommandParts(), other.getCommandParts())) {
            return false;
        }
        List<Bind> this$binds = this.getBinds();
        List<Bind> other$binds = other.getBinds();
        if (this$binds == null ? other$binds != null : !((Object)this$binds).equals(other$binds)) {
            return false;
        }
        if (this.isPrivilegedMode() != other.isPrivilegedMode()) {
            return false;
        }
        List<VolumesFrom> this$volumesFroms = this.getVolumesFroms();
        List<VolumesFrom> other$volumesFroms = other.getVolumesFroms();
        if (this$volumesFroms == null ? other$volumesFroms != null : !((Object)this$volumesFroms).equals(other$volumesFroms)) {
            return false;
        }
        Map<String, LinkableContainer> this$linkedContainers = this.getLinkedContainers();
        Map<String, LinkableContainer> other$linkedContainers = other.getLinkedContainers();
        if (this$linkedContainers == null ? other$linkedContainers != null : !((Object)this$linkedContainers).equals(other$linkedContainers)) {
            return false;
        }
        StartupCheckStrategy this$startupCheckStrategy = this.getStartupCheckStrategy();
        StartupCheckStrategy other$startupCheckStrategy = other.getStartupCheckStrategy();
        if (this$startupCheckStrategy == null ? other$startupCheckStrategy != null : !this$startupCheckStrategy.equals(other$startupCheckStrategy)) {
            return false;
        }
        if (this.getStartupAttempts() != other.getStartupAttempts()) {
            return false;
        }
        String this$workingDirectory = this.getWorkingDirectory();
        String other$workingDirectory = other.getWorkingDirectory();
        if (this$workingDirectory == null ? other$workingDirectory != null : !this$workingDirectory.equals(other$workingDirectory)) {
            return false;
        }
        DockerClient this$dockerClient = this.getDockerClient();
        DockerClient other$dockerClient = other.getDockerClient();
        if (this$dockerClient == null ? other$dockerClient != null : !this$dockerClient.equals(other$dockerClient)) {
            return false;
        }
        Info this$dockerDaemonInfo = this.getDockerDaemonInfo();
        Info other$dockerDaemonInfo = other.getDockerDaemonInfo();
        if (this$dockerDaemonInfo == null ? other$dockerDaemonInfo != null : !((Object)this$dockerDaemonInfo).equals(other$dockerDaemonInfo)) {
            return false;
        }
        String this$containerId = this.getContainerId();
        String other$containerId = other.getContainerId();
        if (this$containerId == null ? other$containerId != null : !this$containerId.equals(other$containerId)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        WaitStrategy this$waitStrategy = this.getWaitStrategy();
        WaitStrategy other$waitStrategy = other.getWaitStrategy();
        if (this$waitStrategy == null ? other$waitStrategy != null : !this$waitStrategy.equals(other$waitStrategy)) {
            return false;
        }
        InspectContainerResponse this$containerInfo = this.getContainerInfo();
        InspectContainerResponse other$containerInfo = other.getContainerInfo();
        if (this$containerInfo == null ? other$containerInfo != null : !this$containerInfo.equals(other$containerInfo)) {
            return false;
        }
        List<Consumer<OutputFrame>> this$logConsumers = this.getLogConsumers();
        List<Consumer<OutputFrame>> other$logConsumers = other.getLogConsumers();
        return !(this$logConsumers == null ? other$logConsumers != null : !((Object)this$logConsumers).equals(other$logConsumers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Integer> $exposedPorts = this.getExposedPorts();
        result = result * 59 + ($exposedPorts == null ? 43 : ((Object)$exposedPorts).hashCode());
        List<String> $portBindings = this.getPortBindings();
        result = result * 59 + ($portBindings == null ? 43 : ((Object)$portBindings).hashCode());
        List<String> $extraHosts = this.getExtraHosts();
        result = result * 59 + ($extraHosts == null ? 43 : ((Object)$extraHosts).hashCode());
        String $networkMode = this.getNetworkMode();
        result = result * 59 + ($networkMode == null ? 43 : $networkMode.hashCode());
        Future<String> $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List<String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCommandParts());
        List<Bind> $binds = this.getBinds();
        result = result * 59 + ($binds == null ? 43 : ((Object)$binds).hashCode());
        result = result * 59 + (this.isPrivilegedMode() ? 79 : 97);
        List<VolumesFrom> $volumesFroms = this.getVolumesFroms();
        result = result * 59 + ($volumesFroms == null ? 43 : ((Object)$volumesFroms).hashCode());
        Map<String, LinkableContainer> $linkedContainers = this.getLinkedContainers();
        result = result * 59 + ($linkedContainers == null ? 43 : ((Object)$linkedContainers).hashCode());
        StartupCheckStrategy $startupCheckStrategy = this.getStartupCheckStrategy();
        result = result * 59 + ($startupCheckStrategy == null ? 43 : $startupCheckStrategy.hashCode());
        result = result * 59 + this.getStartupAttempts();
        String $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : $workingDirectory.hashCode());
        DockerClient $dockerClient = this.getDockerClient();
        result = result * 59 + ($dockerClient == null ? 43 : $dockerClient.hashCode());
        Info $dockerDaemonInfo = this.getDockerDaemonInfo();
        result = result * 59 + ($dockerDaemonInfo == null ? 43 : ((Object)$dockerDaemonInfo).hashCode());
        String $containerId = this.getContainerId();
        result = result * 59 + ($containerId == null ? 43 : $containerId.hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        WaitStrategy $waitStrategy = this.getWaitStrategy();
        result = result * 59 + ($waitStrategy == null ? 43 : $waitStrategy.hashCode());
        InspectContainerResponse $containerInfo = this.getContainerInfo();
        result = result * 59 + ($containerInfo == null ? 43 : $containerInfo.hashCode());
        List<Consumer<OutputFrame>> $logConsumers = this.getLogConsumers();
        result = result * 59 + ($logConsumers == null ? 43 : ((Object)$logConsumers).hashCode());
        return result;
    }

    public static abstract class AbstractWaitStrategy
    implements WaitStrategy {
        protected GenericContainer container;
        @NonNull
        protected Duration startupTimeout = Duration.ofSeconds(60L);

        @Override
        public void waitUntilReady(GenericContainer container) {
            this.container = container;
            this.waitUntilReady();
        }

        protected abstract void waitUntilReady();

        @Override
        public WaitStrategy withStartupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        protected Logger logger() {
            return this.container.logger();
        }

        protected Integer getLivenessCheckPort() {
            return this.container.getLivenessCheckPort();
        }

        protected RateLimiter getRateLimiter() {
            return DOCKER_CLIENT_RATE_LIMITER;
        }
    }
}

