/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testcontainers.shaded.com.google.common.base.MoreObjects;
import org.testcontainers.shaded.com.google.common.base.Objects;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.com.google.common.base.Strings;

public class RemoteApiVersion
implements Serializable {
    private static final long serialVersionUID = -5382212999262115459L;
    private static final Pattern VERSION_REGEX = Pattern.compile("v?(\\d+)\\.(\\d+)");
    public static final RemoteApiVersion VERSION_1_7 = RemoteApiVersion.create(1, 7);
    public static final RemoteApiVersion VERSION_1_16 = RemoteApiVersion.create(1, 16);
    public static final RemoteApiVersion VERSION_1_17 = RemoteApiVersion.create(1, 17);
    public static final RemoteApiVersion VERSION_1_18 = RemoteApiVersion.create(1, 18);
    public static final RemoteApiVersion VERSION_1_19 = RemoteApiVersion.create(1, 19);
    public static final RemoteApiVersion VERSION_1_20 = RemoteApiVersion.create(1, 20);
    public static final RemoteApiVersion VERSION_1_21 = RemoteApiVersion.create(1, 21);
    public static final RemoteApiVersion VERSION_1_22 = RemoteApiVersion.create(1, 22);
    public static final RemoteApiVersion VERSION_1_23 = RemoteApiVersion.create(1, 23);
    public static final RemoteApiVersion VERSION_1_24 = RemoteApiVersion.create(1, 24);
    public static final RemoteApiVersion UNKNOWN_VERSION = new RemoteApiVersion(0, 0){

        @Override
        public boolean isGreaterOrEqual(RemoteApiVersion other) {
            return false;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).addValue("UNKNOWN_VERSION").toString();
        }

        @Override
        public String asWebPathPart() {
            return "";
        }
    };
    private final int major;
    private final int minor;

    private RemoteApiVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static RemoteApiVersion create(int major, int minor) {
        Preconditions.checkArgument(major > 0, "Major version must be bigger than 0 but is " + major);
        Preconditions.checkArgument(minor > 0, "Minor version must be bigger than 0 but is " + minor);
        return new RemoteApiVersion(major, minor);
    }

    public static RemoteApiVersion unknown() {
        return UNKNOWN_VERSION;
    }

    public static RemoteApiVersion parseConfig(String version) {
        Preconditions.checkArgument(version != null, "Version must not be null");
        Matcher matcher = VERSION_REGEX.matcher(version);
        if (matcher.matches()) {
            return RemoteApiVersion.create(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
        }
        throw new IllegalArgumentException(version + " can not be parsed");
    }

    public static RemoteApiVersion parseConfigWithDefault(String version) {
        if (Strings.isNullOrEmpty(version)) {
            return UNKNOWN_VERSION;
        }
        try {
            return RemoteApiVersion.parseConfig(version);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN_VERSION;
        }
    }

    public boolean isGreaterOrEqual(RemoteApiVersion other) {
        return this.major >= other.major && this.minor >= other.minor;
    }

    public String getVersion() {
        return this.major + "." + this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteApiVersion that = (RemoteApiVersion)o;
        return Objects.equal(this.major, that.major) && Objects.equal(this.minor, that.minor);
    }

    public int hashCode() {
        return Objects.hashCode(this.major, this.minor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("major", this.major).add("minor", this.minor).toString();
    }

    public String asWebPathPart() {
        return "v" + this.major + "." + this.minor;
    }
}

