/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder.traits;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;

public interface DockerfileTrait<SELF extends DockerfileTrait<SELF> & BuildContextBuilderTrait<SELF>> {
    default public SELF withDockerfileFromBuilder(Consumer<DockerfileBuilder> builderConsumer) {
        final DockerfileBuilder builder = new DockerfileBuilder();
        builderConsumer.accept(builder);
        return (SELF)((DockerfileTrait)((BuildContextBuilderTrait)((Object)this)).withFileFromTransferable("Dockerfile", new Transferable(){
            private final AtomicReference<Object> bytes = new AtomicReference();

            @Override
            public long getSize() {
                return this.getBytes().length;
            }

            @Override
            public void transferTo(OutputStream outputStream) {
                try {
                    IOUtils.write(this.getBytes(), outputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't transfer Dockerfile", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] getBytes() {
                Object value = this.bytes.get();
                if (value == null) {
                    AtomicReference<Object> atomicReference = this.bytes;
                    synchronized (atomicReference) {
                        value = this.bytes.get();
                        if (value == null) {
                            byte[] actualValue = builder.build().getBytes();
                            value = actualValue == null ? (Object)this.bytes : actualValue;
                            this.bytes.set(value);
                        }
                    }
                }
                return (byte[])(value == this.bytes ? null : value);
            }
        }));
    }
}

