/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildImageResultCallback
extends ResultCallbackTemplate<BuildImageResultCallback, BuildResponseItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildImageResultCallback.class);
    @CheckForNull
    private BuildResponseItem latestItem = null;

    @Override
    public void onNext(BuildResponseItem item) {
        this.latestItem = item;
        LOGGER.debug(item.toString());
    }

    public String awaitImageId() {
        try {
            this.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new DockerClientException("", e);
        }
        return this.getImageId();
    }

    public String awaitImageId(long timeout, TimeUnit timeUnit) {
        try {
            this.awaitCompletion(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            throw new DockerClientException("Awaiting image id interrupted: ", e);
        }
        return this.getImageId();
    }

    private String getImageId() {
        if (this.latestItem == null) {
            throw new DockerClientException("Could not build image");
        }
        if (!this.latestItem.isBuildSuccessIndicated()) {
            throw new DockerClientException("Could not build image: " + this.latestItem.getError());
        }
        return this.latestItem.getImageId();
    }
}

