/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.io.File;
import org.rnorth.tcpunixsocketproxy.TcpToUnixSocketProxy;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.UnixSocketClientProviderStrategy;

public class ProxiedUnixSocketClientProviderStrategy
extends UnixSocketClientProviderStrategy {
    @Override
    public void test() throws DockerClientProviderStrategy.InvalidConfigurationException {
        if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
            throw new DockerClientProviderStrategy.InvalidConfigurationException("this strategy is only applicable to OS X");
        }
        TcpToUnixSocketProxy proxy = new TcpToUnixSocketProxy(new File("/var/run/docker.sock"));
        try {
            int proxyPort = proxy.start().getPort();
            this.config = this.tryConfiguration("tcp://localhost:" + proxyPort);
            LOGGER.info("Accessing Docker for Mac unix domain socket via TCP proxy (/var/run/docker.sock via localhost:" + proxyPort + ")");
        }
        catch (Exception e) {
            proxy.stop();
            throw new DockerClientProviderStrategy.InvalidConfigurationException("ping failed", e);
        }
    }

    @Override
    public String getDescription() {
        return "local Unix socket (via TCP proxy)";
    }
}

