/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testcontainers.shaded.org.bouncycastle.asn1.DERNull;
import org.testcontainers.shaded.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.testcontainers.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testcontainers.shaded.org.bouncycastle.crypto.ExtendedDigest;
import org.testcontainers.shaded.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.testcontainers.shaded.org.bouncycastle.jcajce.io.MacOutputStream;
import org.testcontainers.shaded.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.testcontainers.shaded.org.bouncycastle.jcajce.util.JcaJceHelper;
import org.testcontainers.shaded.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.testcontainers.shaded.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.testcontainers.shaded.org.bouncycastle.operator.GenericKey;
import org.testcontainers.shaded.org.bouncycastle.operator.MacCalculator;
import org.testcontainers.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.testcontainers.shaded.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;

public class JcePKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private ExtendedDigest digest;
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;
    private int saltLength;
    private int iterationCount = 1024;

    public JcePKCS12MacCalculatorBuilder() {
        this(OIWObjectIdentifiers.idSHA1);
    }

    public JcePKCS12MacCalculatorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.algorithm = aSN1ObjectIdentifier;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE);
    }

    public MacCalculator build(final char[] cArray) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            final Mac mac = this.helper.createMac(this.algorithm.getId());
            this.saltLength = mac.getMacLength();
            final byte[] byArray = new byte[this.saltLength];
            this.random.nextBytes(byArray);
            SecretKeyFactory secretKeyFactory = this.helper.createSecretKeyFactory(this.algorithm.getId());
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, this.iterationCount);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            mac.init(secretKey, pBEParameterSpec);
            return new MacCalculator(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return new AlgorithmIdentifier(JcePKCS12MacCalculatorBuilder.this.algorithm, new PKCS12PBEParams(byArray, JcePKCS12MacCalculatorBuilder.this.iterationCount));
                }

                public OutputStream getOutputStream() {
                    return new MacOutputStream(mac);
                }

                public byte[] getMac() {
                    return mac.doFinal();
                }

                public GenericKey getKey() {
                    return new GenericKey(this.getAlgorithmIdentifier(), PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                }
            };
        }
        catch (Exception exception) {
            throw new OperatorCreationException("unable to create MAC calculator: " + exception.getMessage(), exception);
        }
    }
}

