/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.glassfish.jersey.message.internal;

import org.testcontainers.shaded.javax.ws.rs.core.Response;

public final class Statuses {
    public static Response.StatusType from(int code) {
        Response.Status result = Response.Status.fromStatusCode(code);
        return result != null ? result : new StatusImpl(code, "");
    }

    public static Response.StatusType from(int code, String reason) {
        return new StatusImpl(code, reason);
    }

    public static Response.StatusType from(Response.StatusType status, String reason) {
        return new StatusImpl(status.getStatusCode(), reason);
    }

    private Statuses() {
    }

    private static final class StatusImpl
    implements Response.StatusType {
        private int code;
        private String reason;
        private Response.Status.Family family;

        private StatusImpl(int code, String reason) {
            this.code = code;
            this.reason = reason;
            this.family = Response.Status.Family.familyOf(code);
        }

        @Override
        public int getStatusCode() {
            return this.code;
        }

        @Override
        public String getReasonPhrase() {
            return this.reason;
        }

        public String toString() {
            return this.reason;
        }

        @Override
        public Response.Status.Family getFamily() {
            return this.family;
        }
    }
}

