/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Set;
import org.testcontainers.shaded.org.bouncycastle.asn1.BERSequence;
import org.testcontainers.shaded.org.bouncycastle.asn1.DERSet;
import org.testcontainers.shaded.org.bouncycastle.asn1.cms.ContentInfo;
import org.testcontainers.shaded.org.bouncycastle.asn1.cms.SignedData;
import org.testcontainers.shaded.org.bouncycastle.asn1.cms.SignerInfo;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSException;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSProcessable;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSProcessableByteArray;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSSignedHelper;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSTypedData;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSUtils;
import org.testcontainers.shaded.org.bouncycastle.cms.SignerInformation;
import org.testcontainers.shaded.org.bouncycastle.cms.SignerInformationStore;
import org.testcontainers.shaded.org.bouncycastle.cms.SignerInformationVerifier;
import org.testcontainers.shaded.org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.testcontainers.shaded.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.testcontainers.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.testcontainers.shaded.org.bouncycastle.util.Store;

public class CMSSignedData {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSTypedData signedContent;
    SignerInformationStore signerInfoStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData cMSSignedData) {
        this.signedData = cMSSignedData.signedData;
        this.contentInfo = cMSSignedData.contentInfo;
        this.signedContent = cMSSignedData.signedContent;
        this.signerInfoStore = cMSSignedData.signerInfoStore;
    }

    public CMSSignedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, byte[] byArray) throws CMSException {
        this(cMSProcessable, CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(Map map, byte[] byArray) throws CMSException {
        this(map, CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, InputStream inputStream) throws CMSException {
        this(cMSProcessable, CMSUtils.readContentInfo((InputStream)new ASN1InputStream(inputStream)));
    }

    public CMSSignedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSSignedData(final CMSProcessable cMSProcessable, ContentInfo contentInfo) throws CMSException {
        this.signedContent = cMSProcessable instanceof CMSTypedData ? (CMSTypedData)cMSProcessable : new CMSTypedData(){

            public ASN1ObjectIdentifier getContentType() {
                return CMSSignedData.this.signedData.getEncapContentInfo().getContentType();
            }

            public void write(OutputStream outputStream) throws IOException, CMSException {
                cMSProcessable.write(outputStream);
            }

            public Object getContent() {
                return cMSProcessable.getContent();
            }
        };
        this.contentInfo = contentInfo;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(Map map, ContentInfo contentInfo) throws CMSException {
        this.hashes = map;
        this.contentInfo = contentInfo;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        this.signedData = this.getSignedData();
        this.signedContent = this.signedData.getEncapContentInfo().getContent() != null ? new CMSProcessableByteArray(this.signedData.getEncapContentInfo().getContentType(), ((ASN1OctetString)this.signedData.getEncapContentInfo().getContent()).getOctets()) : null;
    }

    private SignedData getSignedData() throws CMSException {
        try {
            return SignedData.getInstance(this.contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set aSN1Set = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            DefaultSignatureAlgorithmIdentifierFinder defaultSignatureAlgorithmIdentifierFinder = new DefaultSignatureAlgorithmIdentifierFinder();
            for (int i = 0; i != aSN1Set.size(); ++i) {
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
                ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signedData.getEncapContentInfo().getContentType();
                if (this.hashes == null) {
                    arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, this.signedContent, null));
                    continue;
                }
                Object k = this.hashes.keySet().iterator().next();
                byte[] byArray = k instanceof String ? (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm().getId()) : (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, null, byArray));
            }
            this.signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this.signerInfoStore;
    }

    public Store getCertificates() {
        return HELPER.getCertificates(this.signedData.getCertificates());
    }

    public Store getCRLs() {
        return HELPER.getCRLs(this.signedData.getCRLs());
    }

    public Store getAttributeCertificates() {
        return HELPER.getAttributeCertificates(this.signedData.getCertificates());
    }

    public Store getOtherRevocationInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return HELPER.getOtherRevocationInfo(aSN1ObjectIdentifier, this.signedData.getCRLs());
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSTypedData getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public boolean verifySignatures(SignerInformationVerifierProvider signerInformationVerifierProvider) throws CMSException {
        return this.verifySignatures(signerInformationVerifierProvider, false);
    }

    public boolean verifySignatures(SignerInformationVerifierProvider signerInformationVerifierProvider, boolean bl) throws CMSException {
        Collection collection = this.getSignerInfos().getSigners();
        for (SignerInformation signerInformation : collection) {
            try {
                SignerInformationVerifier signerInformationVerifier = signerInformationVerifierProvider.get(signerInformation.getSID());
                if (!signerInformation.verify(signerInformationVerifier)) {
                    return false;
                }
                if (bl) continue;
                Collection collection2 = signerInformation.getCounterSignatures().getSigners();
                for (SignerInformation signerInformation2 : collection2) {
                    SignerInformationVerifier signerInformationVerifier2;
                    if (signerInformation2.verify(signerInformationVerifier2 = signerInformationVerifierProvider.get(signerInformation.getSID()))) continue;
                    return false;
                }
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("failure in verifier provider: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
        return true;
    }

    public static CMSSignedData replaceSigners(CMSSignedData cMSSignedData, SignerInformationStore signerInformationStore) {
        Object object2;
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        cMSSignedData2.signerInfoStore = signerInformationStore;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (Object object2 : signerInformationStore.getSigners()) {
            aSN1EncodableVector.add(CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object2).getDigestAlgorithmID()));
            aSN1EncodableVector2.add(((SignerInformation)object2).toASN1Structure());
        }
        object2 = new DERSet(aSN1EncodableVector);
        DERSet dERSet = new DERSet(aSN1EncodableVector2);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)cMSSignedData.signedData.toASN1Primitive();
        aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(0));
        aSN1EncodableVector2.add((ASN1Encodable)object2);
        for (int i = 2; i != aSN1Sequence.size() - 1; ++i) {
            aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(i));
        }
        aSN1EncodableVector2.add(dERSet);
        cMSSignedData2.signedData = SignedData.getInstance(new BERSequence(aSN1EncodableVector2));
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), cMSSignedData2.signedData);
        return cMSSignedData2;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData cMSSignedData, Store store, Store store2, Store store3) throws CMSException {
        Object object;
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        ASN1Set aSN1Set = null;
        Object object2 = null;
        if (store != null || store2 != null) {
            ASN1Set aSN1Set2;
            object = new ArrayList();
            if (store != null) {
                object.addAll(CMSUtils.getCertificatesFromStore(store));
            }
            if (store2 != null) {
                object.addAll(CMSUtils.getAttributeCertificatesFromStore(store2));
            }
            if ((aSN1Set2 = CMSUtils.createBerSetFromList((List)object)).size() != 0) {
                aSN1Set = aSN1Set2;
            }
        }
        if (store3 != null && ((ASN1Set)(object = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(store3)))).size() != 0) {
            object2 = object;
        }
        cMSSignedData2.signedData = new SignedData(cMSSignedData.signedData.getDigestAlgorithms(), cMSSignedData.signedData.getEncapContentInfo(), aSN1Set, (ASN1Set)object2, cMSSignedData.signedData.getSignerInfos());
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), cMSSignedData2.signedData);
        return cMSSignedData2;
    }
}

