/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import org.testcontainers.dockerclient.DockerClientConfigUtils;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;

public class EnvironmentAndSystemPropertyClientProviderStrategy
extends DockerClientProviderStrategy {
    @Override
    public void test() throws DockerClientProviderStrategy.InvalidConfigurationException {
        try {
            this.config = DockerClientConfig.createDefaultConfigBuilder().build();
            DockerClient client = this.getClientForConfig(this.config);
            this.ping(client, 1);
        }
        catch (Exception e) {
            throw new DockerClientProviderStrategy.InvalidConfigurationException("ping failed");
        }
        LOGGER.info("Found docker client settings from environment");
        LOGGER.info("Docker host IP address is {}", (Object)DockerClientConfigUtils.getDockerHostIpAddress(this.config));
    }

    @Override
    public String getDescription() {
        return "Environment variables, system properties and defaults. Resolved: \n" + this.stringRepresentation(this.config);
    }

    private String stringRepresentation(DockerClientConfig config) {
        if (config == null) {
            return "";
        }
        return "    dockerHost=" + config.getDockerHost() + "\n    dockerCertPath='" + config.getDockerCertPath() + "'\n    dockerTlsVerify='" + config.getDockerTlsVerify() + "'\n    apiVersion='" + config.getApiVersion() + "'\n    registryUrl='" + config.getRegistryUrl() + "'\n    registryUsername='" + config.getRegistryUsername() + "'\n    registryPassword='" + config.getRegistryPassword() + "'\n    registryEmail='" + config.getRegistryEmail() + "'\n    dockerConfig='" + config.getDockerConfig() + "'\n";
    }
}

