/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.LogContainerCallback;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.DockerMachineClientProviderStrategy;
import org.testcontainers.dockerclient.EnvironmentAndSystemPropertyClientProviderStrategy;
import org.testcontainers.dockerclient.ProxiedUnixSocketClientProviderStrategy;
import org.testcontainers.dockerclient.UnixSocketClientProviderStrategy;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.api.command.CreateContainerResponse;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.InternalServerErrorException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.NotFoundException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Info;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Version;
import org.testcontainers.shaded.com.github.dockerjava.core.command.LogContainerResultCallback;
import org.testcontainers.shaded.com.github.dockerjava.core.command.PullImageResultCallback;
import org.testcontainers.shaded.com.github.dockerjava.core.command.WaitContainerResultCallback;

public class DockerClientFactory {
    private final Object $lock = new Object[0];
    private static DockerClientFactory instance;
    private static final Logger LOGGER;
    private DockerClientProviderStrategy strategy;
    private boolean preconditionsChecked = false;
    private static final List<DockerClientProviderStrategy> CONFIGURATION_STRATEGIES;
    private String activeApiVersion;
    private String activeExecutionDriver;

    private DockerClientFactory() {
    }

    public static synchronized DockerClientFactory instance() {
        if (instance == null) {
            instance = new DockerClientFactory();
        }
        return instance;
    }

    public DockerClient client() {
        return this.client(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient client(boolean failFast) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.strategy == null) {
                this.strategy = DockerClientProviderStrategy.getFirstValidStrategy(CONFIGURATION_STRATEGIES);
            }
            DockerClient client = this.strategy.getClient();
            if (!this.preconditionsChecked) {
                Info dockerInfo = (Info)client.infoCmd().exec();
                Version version = (Version)client.versionCmd().exec();
                this.activeApiVersion = version.getApiVersion();
                this.activeExecutionDriver = dockerInfo.getExecutionDriver();
                LOGGER.info("Connected to docker: \n  Server Version: " + dockerInfo.getServerVersion() + "\n  API Version: " + this.activeApiVersion + "\n  Operating System: " + dockerInfo.getOperatingSystem() + "\n  Total Memory: " + dockerInfo.getMemTotal() / 0x100000L + " MB");
                this.checkVersion(version.getVersion());
                this.checkDiskSpaceAndHandleExceptions(client);
                this.preconditionsChecked = true;
            }
            if (failFast) {
                client.pingCmd().exec();
            }
            return client;
        }
    }

    public String dockerHostIpAddress() {
        return this.strategy.getDockerHostIpAddress();
    }

    private void checkVersion(String version) {
        String[] splitVersion = version.split("\\.");
        if (Integer.valueOf(splitVersion[0]) <= 1 && Integer.valueOf(splitVersion[1]) < 6) {
            throw new IllegalStateException("Docker version 1.6.0+ is required, but version " + version + " was found");
        }
    }

    private void checkDiskSpaceAndHandleExceptions(DockerClient client) {
        try {
            this.checkDiskSpace(client);
        }
        catch (NotEnoughDiskSpaceException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Encountered and ignored error while checking disk space", e);
        }
    }

    private void checkDiskSpace(DockerClient client) {
        List images = (List)client.listImagesCmd().exec();
        if (!images.stream().anyMatch(it -> Arrays.asList(it.getRepoTags()).contains("alpine:3.2"))) {
            PullImageResultCallback callback = client.pullImageCmd("alpine:3.2").exec(new PullImageResultCallback());
            callback.awaitSuccess();
        }
        CreateContainerResponse createContainerResponse = client.createContainerCmd("alpine:3.2").withCmd("df", "-P").exec();
        String id = createContainerResponse.getId();
        client.startContainerCmd(id).exec();
        LogContainerResultCallback callback = client.logContainerCmd(id).withStdOut(true).exec(new LogContainerCallback());
        try {
            String[] lines;
            WaitContainerResultCallback waitCallback = new WaitContainerResultCallback();
            client.waitContainerCmd(id).exec(waitCallback);
            waitCallback.awaitStarted();
            callback.awaitCompletion();
            String logResults = callback.toString();
            int availableKB = 0;
            int use = 0;
            for (String line : lines = logResults.split("\n")) {
                String[] fields = line.split("\\s+");
                if (!fields[5].equals("/")) continue;
                availableKB = Integer.valueOf(fields[3]);
                use = Integer.valueOf(fields[4].replace("%", ""));
            }
            int availableMB = availableKB / 1024;
            LOGGER.info("Disk utilization in Docker environment is {}% ({} MB available)", (Object)use, (Object)availableMB);
            if (availableMB < 2048) {
                LOGGER.error("Docker environment has less than 2GB free - execution is unlikely to succeed so will be aborted.");
                throw new NotEnoughDiskSpaceException("Not enough disk space in Docker environment");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                client.removeContainerCmd(id).withRemoveVolumes(true).withForce(true).exec();
            }
            catch (InternalServerErrorException | NotFoundException dockerException) {}
        }
    }

    public String getActiveApiVersion() {
        if (!this.preconditionsChecked) {
            this.client(true);
        }
        return this.activeApiVersion;
    }

    public String getActiveExecutionDriver() {
        if (!this.preconditionsChecked) {
            this.client(true);
        }
        return this.activeExecutionDriver;
    }

    public boolean isUsing(Class<? extends DockerClientProviderStrategy> providerStrategyClass) {
        return providerStrategyClass.isAssignableFrom(this.strategy.getClass());
    }

    static {
        LOGGER = LoggerFactory.getLogger(DockerClientFactory.class);
        CONFIGURATION_STRATEGIES = Arrays.asList(new EnvironmentAndSystemPropertyClientProviderStrategy(), new ProxiedUnixSocketClientProviderStrategy(), new UnixSocketClientProviderStrategy(), new DockerMachineClientProviderStrategy());
    }

    private static class NotEnoughDiskSpaceException
    extends RuntimeException {
        NotEnoughDiskSpaceException(String message) {
            super(message);
        }
    }
}

