/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testcontainers.containers.AbstractContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.traits.VncService;
import org.testcontainers.utility.Retryables;

public class BrowserWebDriverContainer
extends AbstractContainer
implements VncService,
LinkableContainer {
    private static final String CHROME_IMAGE = "selenium/standalone-chrome-debug:2.45.0";
    private static final String FIREFOX_IMAGE = "selenium/standalone-firefox-debug:2.45.0";
    private static final String DEFAULT_PASSWORD = "secret";
    private DesiredCapabilities desiredCapabilities;
    private Map<String, LinkableContainer> containersToLink = Collections.emptyMap();
    private String imageName = null;
    private String seleniumPort;
    private String vncPort;

    public BrowserWebDriverContainer(String imageName) {
        this.imageName = imageName;
    }

    public BrowserWebDriverContainer(DesiredCapabilities desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }

    public BrowserWebDriverContainer(DesiredCapabilities desiredCapabilities, Map<String, LinkableContainer> containersToLink) {
        this.desiredCapabilities = desiredCapabilities;
        this.containersToLink = containersToLink;
    }

    protected void containerIsStarting(ContainerInfo containerInfo) {
        Map ports = containerInfo.networkSettings().ports();
        this.seleniumPort = ((PortBinding)((List)ports.get("4444/tcp")).get(0)).hostPort();
        this.vncPort = ((PortBinding)((List)ports.get("5900/tcp")).get(0)).hostPort();
    }

    protected String getLivenessCheckPort() {
        return this.seleniumPort;
    }

    protected ContainerConfig getContainerConfig() {
        String timeZone = System.getProperty("user.timezone");
        if (timeZone == null || timeZone.isEmpty()) {
            timeZone = "Etc/UTC";
        }
        return ContainerConfig.builder().image(this.getDockerImageName()).exposedPorts(new String[]{"4444", "5900"}).env(new String[]{"TZ=" + timeZone}).cmd(new String[]{"/opt/bin/entry_point.sh"}).build();
    }

    protected void customizeHostConfigBuilder(HostConfig.Builder hostConfigBuilder) {
        if (!this.containersToLink.isEmpty()) {
            ArrayList<String> links = new ArrayList<String>();
            for (Map.Entry<String, LinkableContainer> entry : this.containersToLink.entrySet()) {
                links.add(entry.getValue().getContainerName() + ":" + entry.getKey());
            }
            hostConfigBuilder.links(links);
        }
    }

    protected String getDockerImageName() {
        String browserName;
        if (this.imageName != null) {
            return this.imageName;
        }
        switch (browserName = this.desiredCapabilities.getBrowserName()) {
            case "chrome": {
                return CHROME_IMAGE;
            }
            case "firefox": {
                return FIREFOX_IMAGE;
            }
        }
        throw new UnsupportedOperationException("Browser name must be 'chrome' or 'firefox'; provided '" + browserName + "' is not supported");
    }

    public URL getSeleniumAddress() throws MalformedURLException {
        return new URL("http", this.dockerHostIpAddress, Integer.valueOf(this.seleniumPort), "/wd/hub");
    }

    public String getVncAddress() {
        return "vnc://vnc:secret@" + this.dockerHostIpAddress + ":" + this.vncPort;
    }

    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    public int getPort() {
        return 5900;
    }

    protected void waitUntilContainerStarted() {
        Retryables.retryUntilSuccess((int)30, (TimeUnit)TimeUnit.SECONDS, (Retryables.UnreliableSupplier)new Retryables.UnreliableSupplier<RemoteWebDriver>(){

            public RemoteWebDriver get() throws Exception {
                RemoteWebDriver driver = new RemoteWebDriver(BrowserWebDriverContainer.this.getSeleniumAddress(), (Capabilities)BrowserWebDriverContainer.this.desiredCapabilities);
                driver.getCurrentUrl();
                BrowserWebDriverContainer.this.logger().info("Obtained a connection to container ({})", (Object)BrowserWebDriverContainer.this.getSeleniumAddress());
                return driver;
            }
        });
    }
}

