/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.OracleR2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainerProvider;

public class OracleR2DBCDatabaseContainerProvider
implements R2DBCDatabaseContainerProvider {
    static final String DRIVER = "oracle";

    public boolean supports(ConnectionFactoryOptions options) {
        return DRIVER.equals(options.getRequiredValue(ConnectionFactoryOptions.DRIVER));
    }

    public R2DBCDatabaseContainer createContainer(ConnectionFactoryOptions options) {
        String image = OracleContainer.IMAGE + ":" + options.getRequiredValue(IMAGE_TAG_OPTION);
        OracleContainer container = new OracleContainer(image).withDatabaseName((String)options.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        if (Boolean.TRUE.equals(options.getValue(REUSABLE_OPTION))) {
            container.withReuse(true);
        }
        return new OracleR2DBCDatabaseContainer(container);
    }

    @Nullable
    public ConnectionFactoryMetadata getMetadata(ConnectionFactoryOptions options) {
        ConnectionFactoryOptions.Builder builder = options.mutate();
        if (!options.hasOption(ConnectionFactoryOptions.USER)) {
            builder.option(ConnectionFactoryOptions.USER, (Object)"test");
        }
        if (!options.hasOption(ConnectionFactoryOptions.PASSWORD)) {
            builder.option(ConnectionFactoryOptions.PASSWORD, (Object)"test");
        }
        return super.getMetadata(builder.build());
    }
}

