/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.terracotta.voltron.proxy.MethodDescriptor;

public class CommonProxyFactory {
    private static final Comparator<MethodDescriptor> METHOD_COMPARATOR = new Comparator<MethodDescriptor>(){

        @Override
        public int compare(MethodDescriptor m1, MethodDescriptor m2) {
            return m1.toGenericString().compareTo(m2.toGenericString());
        }
    };
    private static final Comparator<Class<?>> CLASS_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static <T, U> Map<U, T> invert(Map<T, U> map) {
        HashMap<U, T> inversion = new HashMap<U, T>();
        for (Map.Entry<T, U> e : map.entrySet()) {
            if (inversion.put(e.getValue(), e.getKey()) == null) continue;
            throw new IllegalArgumentException("Inversion is not a valid map");
        }
        return Collections.unmodifiableMap(inversion);
    }

    public static Map<Byte, MethodDescriptor> createMethodMappings(Class<?> proxyType) {
        SortedSet<MethodDescriptor> methods = CommonProxyFactory.getSortedMethods(proxyType);
        HashMap<Byte, MethodDescriptor> map = new HashMap<Byte, MethodDescriptor>();
        byte index = 0;
        for (MethodDescriptor method : methods) {
            byte by = index;
            index = (byte)(index + 1);
            map.put(by, method);
        }
        return map;
    }

    public static Map<Class<?>, Byte> createResponseTypeMappings(Class<?> proxyType) {
        return CommonProxyFactory.createResponseTypeMappings(proxyType, null);
    }

    public static Map<Class<?>, Byte> createResponseTypeMappings(Class<?> proxyType, Class<?>[] events) {
        HashMap<Class, Byte> map = new HashMap<Class, Byte>();
        byte index = 0;
        for (MethodDescriptor methodDescriptor : CommonProxyFactory.getSortedMethods(proxyType)) {
            Class<?> responseType = methodDescriptor.getMessageType();
            if (map.containsKey(responseType)) continue;
            byte by = index;
            index = (byte)(index + 1);
            map.put(responseType, by);
        }
        if (events != null) {
            for (Class clazz : CommonProxyFactory.getSortedTypes(events)) {
                if (map.containsKey(clazz)) continue;
                byte by = index;
                index = (byte)(index + 1);
                map.put(clazz, by);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static SortedSet<MethodDescriptor> getSortedMethods(Class<?> type) {
        TreeSet<MethodDescriptor> methods = new TreeSet<MethodDescriptor>(METHOD_COMPARATOR);
        if (type == null) {
            return methods;
        }
        Method[] declaredMethods = type.getDeclaredMethods();
        if (declaredMethods.length > 256) {
            throw new IllegalArgumentException("Can't proxy that many methods on a single instance!");
        }
        for (Method declaredMethod : declaredMethods) {
            methods.add(MethodDescriptor.of(declaredMethod));
        }
        if (methods.size() != declaredMethods.length) {
            throw new AssertionError((Object)"Ouch... looks like that didn't work!");
        }
        return methods;
    }

    private static SortedSet<Class<?>> getSortedTypes(Class<?>[] types) {
        TreeSet classes = new TreeSet(CLASS_COMPARATOR);
        if (types != null) {
            classes.addAll(Arrays.asList(types));
        }
        return classes;
    }
}

