/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.voltron.proxy.Codec;

public class SerializationCodec
implements Codec {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationCodec.class);
    private final Pattern shadingPattern;

    public SerializationCodec() {
        this.shadingPattern = null;
    }

    public SerializationCodec(Pattern shadingPattern) {
        this.shadingPattern = Objects.requireNonNull(shadingPattern);
    }

    @Override
    public byte[] encode(Class<?> type, Object value) {
        return this.serialize(value);
    }

    @Override
    public <T> T decode(Class<T> type, byte[] buffer) {
        return this.decode(type, buffer, 0, buffer.length);
    }

    @Override
    public <T> T decode(Class<T> type, byte[] buffer, int offset, int len) {
        return (T)(type.isPrimitive() ? this.deserialize(buffer, offset, len) : type.cast(this.deserialize(buffer, offset, len)));
    }

    @Override
    public byte[] encode(Class<?>[] types, Object[] values) {
        if (values == null) {
            values = new Object[]{};
        }
        if (types.length != values.length) {
            throw new IllegalArgumentException();
        }
        return this.serialize(values);
    }

    @Override
    public Object[] decode(Class<?>[] types, byte[] buffer) {
        return this.decode(types, buffer, 0, buffer.length);
    }

    @Override
    public Object[] decode(Class<?>[] types, byte[] buffer, int offset, int len) {
        Object[] oo = (Object[])this.deserialize(buffer, offset, len);
        for (int i = 0; i < oo.length; ++i) {
            oo[i] = types[i].isPrimitive() ? oo[i] : types[i].cast(oo[i]);
        }
        return oo;
    }

    private byte[] serialize(Object value) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return bout.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private Object deserialize(byte[] buffer, int offset, int len) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ObjectStreamClass checkForCompatibility(ObjectStreamClass descriptor, ObjectStreamClass substitution) throws InvalidClassException {
        if (descriptor.getSerialVersionUID() != substitution.getSerialVersionUID()) {
            throw new InvalidClassException(substitution.getName(), "substitute class incompatible: stream classdesc serialVersionUID = " + descriptor.getSerialVersionUID() + ", substitute class serialVersionUID = " + substitution.getSerialVersionUID());
        }
        LOGGER.debug("Shading Auto-Substitution: {} -> {}", (Object)descriptor, (Object)substitution);
        return substitution;
    }
}

