/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.MessageCodec;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.ProxyEntityMessage;
import org.terracotta.voltron.proxy.ProxyEntityResponse;
import org.terracotta.voltron.proxy.ProxyMessageCodec;
import org.terracotta.voltron.proxy.client.ClientProxyFactory;
import org.terracotta.voltron.proxy.client.ServerMessageAware;

public abstract class ProxyEntityClientService<T extends Entity & ServerMessageAware, C>
implements EntityClientService<T, C, ProxyEntityMessage, ProxyEntityResponse, Object> {
    private final Class<T> clientType;
    private final Class<? super T> type;
    private final Class<C> configType;
    private final Class<?>[] messageTypes;
    private final ProxyMessageCodec messageCodec;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ProxyEntityClientService(Class<T> clientType, Class<? super T> type, Class<C> configType, Class<?>[] messageTypes) {
        this.clientType = clientType;
        this.type = type;
        this.configType = configType;
        this.messageTypes = messageTypes;
        this.messageCodec = new ProxyMessageCodec(type, (Class[])messageTypes);
    }

    public boolean handlesEntityType(Class<T> aClass) {
        return aClass == this.clientType;
    }

    public T create(EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> endpoint, Object userData) {
        return ClientProxyFactory.createEntityProxy(this.clientType, this.type, endpoint, this.messageTypes, this.messageCodec.getCodec());
    }

    public MessageCodec<ProxyEntityMessage, ProxyEntityResponse> getMessageCodec() {
        return this.messageCodec;
    }

    public C deserializeConfiguration(byte[] configuration) {
        if (this.configType == Void.TYPE) {
            return null;
        }
        return this.configType.cast(this.messageCodec.getCodec().decode(this.configType, configuration));
    }

    public byte[] serializeConfiguration(C configuration) {
        if (this.configType == Void.TYPE) {
            return new byte[0];
        }
        return this.messageCodec.getCodec().encode(this.configType, configuration);
    }

    protected void setCodec(Codec codec) {
        this.messageCodec.setCodec(codec);
    }
}

