/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.search.expression;

import java.util.Collection;
import java.util.Iterator;
import org.terracotta.toolkit.search.SearchException;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeType;
import org.terracotta.toolkit.search.expression.BaseClause;

public class OneOf
extends BaseClause {
    private final String attributeName;
    private final Collection<?> values;

    public OneOf(String attributeName, Collection<?> values) {
        if (attributeName == null || values == null) {
            throw new NullPointerException();
        }
        this.attributeName = attributeName;
        this.values = values;
        if (!values.isEmpty()) {
            this.verifyCommonType();
        }
    }

    private void verifyCommonType() {
        if (this.values.isEmpty()) {
            throw new AssertionError();
        }
        ToolkitAttributeType rv = null;
        for (Object value : this.values) {
            if (value == null) {
                throw new NullPointerException("null element in set");
            }
            ToolkitAttributeType at = ToolkitAttributeType.typeFor(this.attributeName, value);
            if (rv == null) {
                rv = at;
                continue;
            }
            if (at == rv) continue;
            throw new SearchException("Multiple types detected in collection: " + (Object)((Object)at) + " and " + (Object)((Object)rv));
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Collection<?> values() {
        return this.values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attributeName).append(" ").append("IN").append(" ").append("{");
        Iterator<?> itr = this.values.iterator();
        boolean go = itr.hasNext();
        while (go) {
            sb.append(itr.next());
            go = itr.hasNext();
            if (!go) continue;
            sb.append(",").append(" ");
        }
        sb.append("}");
        return sb.toString();
    }
}

