/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.search;

import java.util.Collection;
import org.terracotta.toolkit.search.AggregateFunction;
import org.terracotta.toolkit.search.expression.Clause;
import org.terracotta.toolkit.search.expression.Equals;
import org.terracotta.toolkit.search.expression.Matches;
import org.terracotta.toolkit.search.expression.OneOf;
import org.terracotta.toolkit.search.expression.Range;
import org.terracotta.toolkit.search.expression.RelationalClause;

public class Attribute<T> {
    private final String attributeName;

    public Attribute(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException();
        }
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Clause range(T min, T max) {
        return this.range(min, max, true, true);
    }

    public Clause range(T min, T max, boolean minInclusive, boolean maxInclusive) {
        return new Range(this.attributeName, min, max, minInclusive, maxInclusive);
    }

    public Clause oneOf(Collection<? extends T> values) {
        return new OneOf(this.attributeName, values);
    }

    public Clause ne(T value) {
        return new Equals(this.attributeName, value).not();
    }

    public Clause lt(T value) {
        return RelationalClause.lt(this.attributeName, value);
    }

    public Clause le(T value) {
        return RelationalClause.lte(this.attributeName, value);
    }

    public Clause gt(T value) {
        return RelationalClause.gt(this.attributeName, value);
    }

    public Clause ge(T value) {
        return RelationalClause.gte(this.attributeName, value);
    }

    public Clause eq(T value) {
        return new Equals(this.attributeName, value);
    }

    public Clause matches(String regex) {
        return new Matches(this.attributeName, regex);
    }

    public AggregateFunction count() {
        return AggregateFunction.count();
    }

    public AggregateFunction max() {
        return AggregateFunction.max(this.attributeName);
    }

    public AggregateFunction min() {
        return AggregateFunction.min(this.attributeName);
    }

    public AggregateFunction sum() {
        return AggregateFunction.sum(this.attributeName);
    }

    public AggregateFunction average() {
        return AggregateFunction.average(this.attributeName);
    }

    public String toString() {
        return this.attributeName;
    }

    public int hashCode() {
        return this.attributeName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attribute) {
            Attribute other = (Attribute)obj;
            return this.attributeName.equals(other.attributeName);
        }
        return false;
    }
}

