/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit;

import java.util.ArrayList;
import java.util.List;
import org.terracotta.toolkit.ToolkitFeature;
import org.terracotta.toolkit.feature.NonStopFeature;
import org.terracotta.toolkit.feature.OffheapFeature;
import org.terracotta.toolkit.feature.SearchFeature;

public final class ToolkitFeatureType<T extends ToolkitFeature> {
    private static final List<ToolkitFeatureType> features = new ArrayList<ToolkitFeatureType>();
    public static final ToolkitFeatureType<OffheapFeature> OFFHEAP = ToolkitFeatureType.define(OffheapFeature.class);
    public static final ToolkitFeatureType<SearchFeature> SEARCH = ToolkitFeatureType.define(SearchFeature.class);
    public static final ToolkitFeatureType<NonStopFeature> NONSTOP = ToolkitFeatureType.define(NonStopFeature.class);
    private final Class<T> clazz;

    private static <F extends ToolkitFeature> ToolkitFeatureType<F> define(Class<F> clazz) {
        ToolkitFeatureType<F> type = new ToolkitFeatureType<F>(clazz);
        if (features.contains(type)) {
            throw new AssertionError((Object)("Cannot define multiple times for same feature interface - " + clazz.getName()));
        }
        features.add(type);
        return type;
    }

    public static ToolkitFeatureType[] values() {
        return features.toArray(new ToolkitFeatureType[0]);
    }

    private ToolkitFeatureType(Class<T> clazz) {
        if (clazz == null) {
            throw new AssertionError();
        }
        this.clazz = clazz;
    }

    public Class<T> getFeatureClass() {
        return this.clazz;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolkitFeatureType other = (ToolkitFeatureType)obj;
        return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
    }

    public String toString() {
        return "ToolkitFeatureType [clazz=" + this.clazz.getName() + "]";
    }
}

