/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ThrowsMatcher
extends TypeSafeMatcher<Task> {
    private static final Throwable SENTINEL = new Throwable();
    private final Matcher<? extends Throwable> matcher;
    private Throwable fault = SENTINEL;

    public ThrowsMatcher(Matcher<? extends Throwable> matcher) {
        this.matcher = matcher;
    }

    protected boolean matchesSafely(Task task) {
        try {
            task.run();
            this.fault = null;
            return false;
        }
        catch (Throwable t) {
            this.fault = t;
            return this.matcher.matches((Object)t);
        }
    }

    protected void describeMismatchSafely(Task item, Description mismatchDescription) {
        if (this.fault == SENTINEL) {
            throw new IllegalStateException("The task has not been called");
        }
        if (this.fault == null) {
            mismatchDescription.appendText("the task completed normally");
        } else {
            this.matcher.describeMismatch((Object)this.fault, mismatchDescription.appendText("the thrown "));
        }
    }

    public void describeTo(Description description) {
        description.appendText("a task that throws ").appendDescriptionOf(this.matcher);
    }

    public static Matcher<Task> threw(Matcher<? extends Throwable> matcher) {
        return new ThrowsMatcher(matcher);
    }

    @FunctionalInterface
    public static interface Task {
        public void run() throws Throwable;
    }
}

