/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test;

import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class ModuleSupport {
    private static final MethodHandle GET_MODULE_METHOD;
    private static final MethodHandle IS_OPEN_METHOD;
    private static final Object UNNAMED_MODULE;

    public static boolean isOpen(Object ref) {
        return ModuleSupport.isOpen(ref.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOpen(Class<?> targetClass) {
        if (UNNAMED_MODULE == null) {
            return true;
        }
        try {
            Object module = GET_MODULE_METHOD.invoke(targetClass);
            String packageName = targetClass.getPackage().getName();
            return IS_OPEN_METHOD.invoke(module, packageName, UNNAMED_MODULE);
        }
        catch (Throwable e) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.format("Unable to determine module open state for %s%n", targetClass.getName());
                e.printStackTrace(System.err);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        MethodHandle getModuleMethod = null;
        Object unnamedModule = null;
        MethodHandle isOpenMethod = null;
        try {
            Class<?> moduleClass = Class.forName("java.lang.Module");
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                getModuleMethod = lookup.findVirtual(Class.class, "getModule", MethodType.methodType(moduleClass));
                MethodHandle getUnnamedModuleMethod = lookup.findVirtual(ClassLoader.class, "getUnnamedModule", MethodType.methodType(moduleClass));
                unnamedModule = getUnnamedModuleMethod.invoke(ModuleSupport.class.getClassLoader());
                isOpenMethod = lookup.findVirtual(moduleClass, "isOpen", MethodType.methodType(Boolean.TYPE, String.class, moduleClass));
            }
            catch (Throwable e) {
                throw new AssertionError("Failed to obtain references to Module support methods", e);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            GET_MODULE_METHOD = getModuleMethod;
            UNNAMED_MODULE = unnamedModule;
            IS_OPEN_METHOD = isOpenMethod;
        }
    }
}

