/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.org.junit.rules;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class TemporaryFolder
extends ExternalResource {
    private final File parentFolder;
    private final boolean assureDeletion;
    private File folder;
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final String TMP_PREFIX = "junit";

    public TemporaryFolder() {
        this((File)null);
    }

    public TemporaryFolder(File parentFolder) {
        this.parentFolder = parentFolder;
        this.assureDeletion = false;
    }

    protected TemporaryFolder(Builder builder) {
        this.parentFolder = builder.parentFolder;
        this.assureDeletion = builder.assureDeletion;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void before() throws Throwable {
        this.create();
    }

    protected void after() {
        this.delete();
    }

    public void create() throws IOException {
        this.folder = TemporaryFolder.createTemporaryFolderIn(this.parentFolder);
    }

    public File newFile(String fileName) throws IOException {
        File file = new File(this.getRoot(), fileName);
        if (!file.createNewFile()) {
            throw new IOException("a file with the name '" + fileName + "' already exists in the test folder");
        }
        return file;
    }

    public File newFile() throws IOException {
        return File.createTempFile(TMP_PREFIX, null, this.getRoot());
    }

    public File newFolder(String path) throws IOException {
        return this.newFolder(new String[]{path});
    }

    public File newFolder(String ... paths) throws IOException {
        if (paths.length == 0) {
            throw new IllegalArgumentException("must pass at least one path");
        }
        File root = this.getRoot();
        for (String path : paths) {
            if (!new File(path).isAbsolute()) continue;
            throw new IOException("folder path '" + path + "' is not a relative path");
        }
        File relativePath = null;
        File file = root;
        boolean lastMkdirsCallSuccessful = true;
        for (String path : paths) {
            file = new File(root, (relativePath = new File(relativePath, path)).getPath());
            lastMkdirsCallSuccessful = file.mkdirs();
            if (lastMkdirsCallSuccessful || file.isDirectory()) continue;
            if (file.exists()) {
                throw new IOException("a file with the path '" + relativePath.getPath() + "' exists");
            }
            throw new IOException("could not create a folder with the path '" + relativePath.getPath() + "'");
        }
        if (!lastMkdirsCallSuccessful) {
            throw new IOException("a folder with the path '" + relativePath.getPath() + "' already exists");
        }
        return file;
    }

    public File newFolder() throws IOException {
        return TemporaryFolder.createTemporaryFolderIn(this.getRoot());
    }

    private static File createTemporaryFolderIn(File parentFolder) throws IOException {
        try {
            return TemporaryFolder.createTemporaryFolderWithNioApi(parentFolder);
        }
        catch (ClassNotFoundException ignore) {
            return TemporaryFolder.createTemporaryFolderWithFileApi(parentFolder);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            IOException exception = new IOException("Failed to create temporary folder in " + parentFolder);
            exception.initCause(cause);
            throw exception;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create temporary folder in " + parentFolder, e);
        }
    }

    private static File createTemporaryFolderWithNioApi(File parentFolder) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object tempDir;
        Class<?> filesClass = Class.forName("java.nio.file.Files");
        Object fileAttributeArray = Array.newInstance(Class.forName("java.nio.file.attribute.FileAttribute"), 0);
        Class<?> pathClass = Class.forName("java.nio.file.Path");
        if (parentFolder != null) {
            Method createTempDirectoryMethod = filesClass.getDeclaredMethod("createTempDirectory", pathClass, String.class, fileAttributeArray.getClass());
            Object parentPath = File.class.getDeclaredMethod("toPath", new Class[0]).invoke((Object)parentFolder, new Object[0]);
            tempDir = createTempDirectoryMethod.invoke(null, parentPath, TMP_PREFIX, fileAttributeArray);
        } else {
            Method createTempDirectoryMethod = filesClass.getDeclaredMethod("createTempDirectory", String.class, fileAttributeArray.getClass());
            tempDir = createTempDirectoryMethod.invoke(null, TMP_PREFIX, fileAttributeArray);
        }
        return (File)pathClass.getDeclaredMethod("toFile", new Class[0]).invoke(tempDir, new Object[0]);
    }

    private static File createTemporaryFolderWithFileApi(File parentFolder) throws IOException {
        File createdFolder = null;
        for (int i = 0; i < 10000; ++i) {
            String suffix = ".tmp";
            File tmpFile = File.createTempFile(TMP_PREFIX, suffix, parentFolder);
            String tmpName = tmpFile.toString();
            String folderName = tmpName.substring(0, tmpName.length() - suffix.length());
            createdFolder = new File(folderName);
            if (createdFolder.mkdir()) {
                tmpFile.delete();
                return createdFolder;
            }
            tmpFile.delete();
        }
        throw new IOException("Unable to create temporary directory in: " + parentFolder.toString() + ". Tried " + 10000 + " times. Last attempted to create: " + createdFolder.toString());
    }

    public File getRoot() {
        if (this.folder == null) {
            throw new IllegalStateException("the temporary folder has not yet been created");
        }
        return this.folder;
    }

    public void delete() {
        if (!this.tryDelete() && this.assureDeletion) {
            Assert.fail((String)("Unable to clean up temporary folder " + this.folder));
        }
    }

    private boolean tryDelete() {
        if (this.folder == null) {
            return true;
        }
        return this.recursiveDelete(this.folder);
    }

    private boolean recursiveDelete(File file) {
        if (file.delete()) {
            return true;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File each : files) {
                if (this.recursiveDelete(each)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static class Builder {
        private File parentFolder;
        private boolean assureDeletion;

        protected Builder() {
        }

        public Builder parentFolder(File parentFolder) {
            this.parentFolder = parentFolder;
            return this;
        }

        public Builder assureDeletion() {
            this.assureDeletion = true;
            return this;
        }

        public TemporaryFolder build() {
            return new TemporaryFolder(this);
        }
    }
}

