/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.registry;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.terracotta.statistics.Sample;
import org.terracotta.statistics.StatisticType;

public class Statistic<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StatisticType type;
    private final List<Sample<T>> samples;

    public Statistic(StatisticType type, List<Sample<T>> samples) {
        this.type = type;
        this.samples = samples;
    }

    public StatisticType getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.samples.isEmpty();
    }

    public List<Sample<T>> getSamples() {
        return this.samples;
    }

    public Optional<T> getLatestSample() {
        return this.samples.isEmpty() ? Optional.empty() : Optional.of(this.samples.get(this.samples.size() - 1).getSample());
    }

    public String toString() {
        return "Statistic{type=" + (Object)((Object)this.type) + ", samples=" + this.samples + '}';
    }
}

