/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.storage;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.storage.PortabilityBasedStorageEngine;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.storage.portability.WriteContext;
import org.terracotta.offheapstore.util.ByteBufferUtils;
import org.terracotta.offheapstore.util.DebuggingUtils;
import org.terracotta.offheapstore.util.Factory;

public class OffHeapBufferStorageEngine<K, V>
extends PortabilityBasedStorageEngine<K, V>
implements OffHeapStorageArea.Owner {
    private static final int KEY_HASH_OFFSET = 0;
    private static final int KEY_LENGTH_OFFSET = 4;
    private static final int VALUE_LENGTH_OFFSET = 8;
    private static final int DATA_OFFSET = 12;
    private static final int HEADER_SIZE = 12;
    protected final OffHeapStorageArea storageArea;
    protected volatile StorageEngine.Owner owner;

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        return () -> new OffHeapBufferStorageEngine(width, source, pageSize, keyPortability, valuePortability, thief, victim);
    }

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        return () -> new OffHeapBufferStorageEngine(width, source, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
    }

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        return () -> new OffHeapBufferStorageEngine(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim);
    }

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        return () -> new OffHeapBufferStorageEngine(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability, compressThreshold);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, false, false);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        this(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, false, false, compressThreshold);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability, thief, victim);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        this(width, source, pageSize, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(keyPortability, valuePortability);
        this.storageArea = new OffHeapStorageArea(width, (OffHeapStorageArea.Owner)this, source, initialPageSize, maximalPageSize, thief, victim);
    }

    public OffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        super(keyPortability, valuePortability);
        this.storageArea = new OffHeapStorageArea(width, this, source, initialPageSize, maximalPageSize, thief, victim, compressThreshold);
    }

    @Override
    protected void clearInternal() {
        this.storageArea.clear();
    }

    @Override
    protected void free(long address) {
        this.storageArea.free(address);
    }

    @Override
    public ByteBuffer readKeyBuffer(long address) {
        int length = this.storageArea.readInt(address + 4L);
        return this.storageArea.readBuffer(address + 12L, length).asReadOnlyBuffer();
    }

    @Override
    protected WriteContext getKeyWriteContext(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        return this.getWriteContext(address + 12L, keyLength);
    }

    @Override
    public ByteBuffer readValueBuffer(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        int valueLength = this.storageArea.readInt(address + 8L);
        return this.storageArea.readBuffer(address + 12L + (long)keyLength, valueLength).asReadOnlyBuffer();
    }

    @Override
    protected WriteContext getValueWriteContext(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        int valueLength = this.storageArea.readInt(address + 8L);
        return this.getWriteContext(address + 12L + (long)keyLength, valueLength);
    }

    private WriteContext getWriteContext(final long address, final int max) {
        return new WriteContext(){

            @Override
            public void setLong(int offset, long value) {
                if (offset < 0 || offset > max) {
                    throw new IllegalArgumentException();
                }
                OffHeapBufferStorageEngine.this.storageArea.writeLong(address + (long)offset, value);
            }

            @Override
            public void flush() {
            }
        };
    }

    @Override
    protected Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int hash) {
        int valueLength;
        int keyLength = keyBuffer.remaining();
        long address = this.storageArea.allocate(keyLength + (valueLength = valueBuffer.remaining()) + 12);
        if (address >= 0L) {
            this.storageArea.writeInt(address + 0L, hash);
            this.storageArea.writeInt(address + 4L, keyLength);
            this.storageArea.writeInt(address + 8L, valueLength);
            this.storageArea.writeBuffer(address + 12L, keyBuffer);
            this.storageArea.writeBuffer(address + 12L + (long)keyLength, valueBuffer);
            return address;
        }
        return null;
    }

    @Override
    protected Long writeMappingBuffersGathering(ByteBuffer[] keyBuffers, ByteBuffer[] valueBuffers, int hash) {
        int valueLength;
        int keyLength = ByteBufferUtils.totalLength(keyBuffers);
        long address = this.storageArea.allocate(keyLength + (valueLength = ByteBufferUtils.totalLength(valueBuffers)) + 12);
        if (address >= 0L) {
            this.storageArea.writeInt(address + 0L, hash);
            this.storageArea.writeInt(address + 4L, keyLength);
            this.storageArea.writeInt(address + 8L, valueLength);
            this.storageArea.writeBuffers(address + 12L, keyBuffers);
            this.storageArea.writeBuffers(address + 12L + (long)keyLength, valueBuffers);
            return address;
        }
        return null;
    }

    @Override
    public long getAllocatedMemory() {
        return this.storageArea.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.storageArea.getOccupiedMemory();
    }

    @Override
    public long getVitalMemory() {
        return this.getAllocatedMemory();
    }

    @Override
    public long getDataSize() {
        return this.getOccupiedMemory();
    }

    public String toString() {
        return "OffHeapBufferStorageEngine allocated=" + DebuggingUtils.toBase2SuffixedString(this.getAllocatedMemory()) + "B occupied=" + DebuggingUtils.toBase2SuffixedString(this.getOccupiedMemory()) + "B\nStorage Area: " + this.storageArea;
    }

    @Override
    public void destroy() {
        this.storageArea.destroy();
    }

    @Override
    public boolean shrink() {
        return this.storageArea.shrink();
    }

    @Override
    public Collection<Long> evictAtAddress(long address, boolean shrink) {
        int hash = this.storageArea.readInt(address + 0L);
        int slot = this.owner.getSlotForHashAndEncoding(hash, address, -1L);
        if (this.owner.evict(slot, shrink)) {
            return Collections.singleton(address);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isThief() {
        return this.owner.isThiefForTableAllocations();
    }

    @Override
    public int readKeyHash(long encoding) {
        return this.storageArea.readInt(encoding + 0L);
    }

    @Override
    public boolean moved(long from, long to) {
        return this.owner.updateEncoding(this.readKeyHash(to), from, to, -1L);
    }

    @Override
    public int sizeOf(long address) {
        int keyLength = this.storageArea.readInt(address + 4L);
        int valueLength = this.storageArea.readInt(address + 8L);
        return 12 + keyLength + valueLength;
    }

    @Override
    public void bind(StorageEngine.Owner m) {
        if (this.owner != null) {
            throw new AssertionError();
        }
        this.owner = m;
    }

    @Override
    public Lock writeLock() {
        return this.owner.writeLock();
    }
}

