/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.value;

import com.tc.object.bytecode.ManagerUtil;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.CacheConfigFactory;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.value.AbstractTimestampedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatelessTimestampedValue<V>
implements TimestampedValue<V> {
    protected static final int UNUSED = 0;

    protected abstract CapacityEvictionPolicyData fastGetCapacityEvictionPolicyData();

    @Override
    public abstract V getValue();

    @Override
    public final void markUsed(int usedAtTime, String lockId, CacheConfig config) {
        boolean capacityEviction = config.getTargetMaxInMemoryCount() > 0 || config.getTargetMaxTotalCount() > 0;
        int configTTI = config.getMaxTTISeconds();
        if (configTTI == 1) {
            ++usedAtTime;
        }
        if (this.shouldUpdateIdleTimer(usedAtTime, configTTI)) {
            this.setLastAccessedTime(usedAtTime, lockId);
        }
        if (capacityEviction) {
            if (!config.getCapacityEvictionPolicyDataFactory().isProductOfFactory(this.fastGetCapacityEvictionPolicyData())) {
                this.setCapacityEvictionPolicyData(config.getCapacityEvictionPolicyDataFactory().newCapacityEvictionPolicyData());
            }
            this.fastGetCapacityEvictionPolicyData().markUsed(usedAtTime);
        }
    }

    @Override
    public abstract int getLastAccessedTime();

    protected abstract void setLastAccessedTimeInternal(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setLastAccessedTime(int usedAtTime, String lockId) {
        if (CacheConfigFactory.DSO_ACTIVE) {
            ManagerUtil.beginLock((String)lockId, (int)4);
            try {
                this.setLastAccessedTimeInternal(usedAtTime);
            }
            finally {
                ManagerUtil.commitLock((String)lockId, (int)4);
            }
        } else {
            this.setLastAccessedTimeInternal(usedAtTime);
        }
    }

    private boolean shouldUpdateIdleTimer(int usedAtTime, int configTTI) {
        int halfTTI;
        if (configTTI == 0) {
            return false;
        }
        int timeSinceUsed = usedAtTime - this.getLastAccessedTime();
        return timeSinceUsed >= (halfTTI = configTTI / 2);
    }

    @Override
    public final boolean isExpired(int atTime, CacheConfig config) {
        int expiresAt = this.expiresAt(config);
        return atTime >= expiresAt;
    }

    @Override
    public int expiresAt(CacheConfig config) {
        int configTTI = config.getMaxTTISeconds();
        int configTTL = config.getMaxTTLSeconds();
        if (configTTI == 0 && configTTL == 0) {
            return Integer.MAX_VALUE;
        }
        int expiresAtTTL = configTTL == 0 || configTTL < 0 ? Integer.MAX_VALUE : this.getCreateTime() + configTTL;
        int expiresAtTTI = configTTI == 0 || configTTI < 0 ? Integer.MAX_VALUE : this.getLastAccessedTime() + configTTI;
        return Math.min(expiresAtTTI, expiresAtTTL);
    }

    @Override
    public abstract int getCreateTime();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractTimestampedValue) {
            TimestampedValue other = (TimestampedValue)obj;
            V thisValue = this.getValue();
            if (other.getValue() == null) {
                if (thisValue == null) {
                    return true;
                }
            } else if (thisValue != null) {
                return other.getValue().equals(thisValue);
            }
        }
        return false;
    }

    public int hashCode() {
        V value = this.getValue();
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.getValue() + ">";
    }
}

