/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.serialization;

import com.tc.object.bytecode.TransparentAccess;
import java.io.IOException;
import java.lang.reflect.Field;
import org.terracotta.cache.CacheConfigFactory;
import org.terracotta.cache.impl.TimeSource;
import org.terracotta.cache.serialization.SerializationStrategy;
import org.terracotta.cache.value.AbstractTimestampedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedEntry<T>
extends AbstractTimestampedValue<byte[]> {
    private final byte[] value;
    private final int createTime;
    private transient T cached;
    private static final String VALUE_FIELD;

    public SerializedEntry(T deserialized, byte[] serialized, TimeSource timeSource) {
        this(deserialized, serialized, timeSource.now());
    }

    public SerializedEntry(T deserialized, byte[] serialized, int createTime) {
        this(deserialized, serialized, createTime, createTime);
    }

    public SerializedEntry(T deserialized, byte[] serialized, int createTime, int lastAccessedTime) {
        this.value = serialized;
        this.createTime = createTime;
        this.setLastAccessedTimeInternal(lastAccessedTime);
        this.cached = deserialized;
    }

    public T getDeserializedValueCopy(SerializationStrategy<T> strategy) throws IOException, ClassNotFoundException {
        return strategy.deserialize(this.getValue());
    }

    public T getDeserializedValueCopy(SerializationStrategy<T> strategy, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return strategy.deserialize(this.getValue(), classLoader);
    }

    public synchronized T getDeserializedValue(SerializationStrategy<T> strategy) throws IOException, ClassNotFoundException {
        if (this.cached == null) {
            this.cached = strategy.deserialize(this.getValue());
            this.nullByteArray();
        }
        return this.cached;
    }

    public synchronized T getDeserializedValue(SerializationStrategy<T> strategy, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (this.cached == null) {
            this.cached = strategy.deserialize(this.getValue(), classLoader);
            this.nullByteArray();
        }
        return this.cached;
    }

    public void nullByteArray() {
        if (!CacheConfigFactory.DSO_ACTIVE) {
            return;
        }
        ((TransparentAccess)this).__tc_setfield(VALUE_FIELD, null);
        if (this.value != null) {
            throw new AssertionError();
        }
    }

    @Override
    public int getCreateTime() {
        return this.createTime;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    static {
        Class<SerializedEntry> c = SerializedEntry.class;
        try {
            Field valueField = c.getDeclaredField("value");
            VALUE_FIELD = c.getName() + "." + valueField.getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

