/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.impl;

import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.CacheConfigFactory;
import org.terracotta.cache.DistributedCache;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.impl.DistributedCacheImpl;
import org.terracotta.cache.impl.LocalCache;
import org.terracotta.cache.impl.MutableConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableConfig
implements CacheConfig {
    private final String name;
    private final int maxTTISeconds;
    private final int maxTTLSeconds;
    private final boolean orphanEvictionEnabled;
    private final int orphanEvictionPeriod;
    private final boolean loggingEnabled;
    private final int targetMaxInMemoryCount;
    private final int targetMaxTotalCount;
    private final CapacityEvictionPolicyData.Factory capacityEvictionPolicyDataFactory;

    public ImmutableConfig(String name, boolean loggingEnabled, int maxTTISeconds, int maxTTLSeconds, boolean orphanEvictionEnabled, int orphanEvictionPeriod, int targetMaxInMemoryCount, int targetMaxTotalCount, CapacityEvictionPolicyData.Factory capacityEvictionPolicyDataFactory) {
        this.name = name;
        this.loggingEnabled = loggingEnabled;
        this.maxTTISeconds = maxTTISeconds;
        this.maxTTLSeconds = maxTTLSeconds;
        this.orphanEvictionEnabled = orphanEvictionEnabled;
        this.orphanEvictionPeriod = orphanEvictionPeriod;
        this.targetMaxInMemoryCount = targetMaxInMemoryCount;
        this.targetMaxTotalCount = targetMaxTotalCount;
        this.capacityEvictionPolicyDataFactory = capacityEvictionPolicyDataFactory;
    }

    public ImmutableConfig(CacheConfig config) {
        this.name = config.getName();
        this.loggingEnabled = config.isLoggingEnabled();
        this.maxTTISeconds = config.getMaxTTISeconds();
        this.maxTTLSeconds = config.getMaxTTLSeconds();
        this.orphanEvictionEnabled = config.isOrphanEvictionEnabled();
        this.orphanEvictionPeriod = config.getOrphanEvictionPeriod();
        this.targetMaxInMemoryCount = config.getTargetMaxInMemoryCount();
        this.targetMaxTotalCount = config.getTargetMaxTotalCount();
        this.capacityEvictionPolicyDataFactory = config.getCapacityEvictionPolicyDataFactory();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxTTISeconds() {
        return this.maxTTISeconds;
    }

    @Override
    public int getMaxTTLSeconds() {
        return this.maxTTLSeconds;
    }

    @Override
    public boolean isOrphanEvictionEnabled() {
        return this.orphanEvictionEnabled;
    }

    @Override
    public int getOrphanEvictionPeriod() {
        return this.orphanEvictionPeriod;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public boolean isEvictionEnabled() {
        return this.getMaxTTISeconds() > 0 || this.getMaxTTLSeconds() > 0;
    }

    @Override
    public int getTargetMaxInMemoryCount() {
        return this.targetMaxInMemoryCount;
    }

    @Override
    public int getTargetMaxTotalCount() {
        return this.targetMaxTotalCount;
    }

    @Override
    public boolean refresh() {
        return false;
    }

    @Override
    public CapacityEvictionPolicyData.Factory getCapacityEvictionPolicyDataFactory() {
        return this.capacityEvictionPolicyDataFactory;
    }

    @Override
    public void waitForChange(long maxWait) {
        try {
            Thread.sleep(maxWait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loggingEnabled ? 1231 : 1237);
        result = 31 * result + this.maxTTISeconds;
        result = 31 * result + this.maxTTLSeconds;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.orphanEvictionEnabled ? 1231 : 1237);
        result = 31 * result + this.orphanEvictionPeriod;
        result = 31 * result + this.targetMaxInMemoryCount;
        result = 31 * result + this.targetMaxTotalCount;
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutableConfig)) {
            return false;
        }
        ImmutableConfig config = (ImmutableConfig)o;
        return this.getName().equals(config.getName()) && this.getMaxTTISeconds() == config.getMaxTTISeconds() && this.getMaxTTLSeconds() == config.getMaxTTLSeconds() && this.isOrphanEvictionEnabled() == config.isOrphanEvictionEnabled() && this.getOrphanEvictionPeriod() == config.getOrphanEvictionPeriod() && this.isLoggingEnabled() == config.isLoggingEnabled() && this.getTargetMaxInMemoryCount() == config.getTargetMaxInMemoryCount() && this.getTargetMaxTotalCount() == config.getTargetMaxTotalCount();
    }

    @Override
    public <K, V> DistributedCache<K, V> newCache() {
        MutableConfig copyConfig = new MutableConfig(this.name, this.loggingEnabled, this.maxTTISeconds, this.maxTTLSeconds, this.orphanEvictionEnabled, this.orphanEvictionPeriod, this.targetMaxInMemoryCount, this.targetMaxTotalCount, this.capacityEvictionPolicyDataFactory);
        if (CacheConfigFactory.DSO_ACTIVE) {
            return new DistributedCacheImpl(copyConfig);
        }
        return new LocalCache(copyConfig);
    }

    @Override
    public CacheConfig setLoggingEnabled(boolean loggingEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setMaxTTISeconds(int maxTTISeconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setMaxTTLSeconds(int maxTTLSeconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setOrphanEvictionEnabled(boolean orphanEvictionEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setOrphanEvictionPeriod(int orphanEvictionPeriod) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setTargetMaxInMemoryCount(int targetMaxInMemoryCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setTargetMaxTotalCount(int targetMaxTotalCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheConfig setCapacityEvictionPolicyDataFactory(CapacityEvictionPolicyData.Factory type) {
        throw new UnsupportedOperationException();
    }
}

