/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.evictor.TargetCapacityEvictor;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.collections.MapSizeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetCapacityMapSizeListener<K>
implements MapSizeListener {
    private static final float OVERSHOOT_RATIO = 0.01f;
    private static final int OVERSHOOT_MINIMUM = 10;
    private static final int MAX_EVICTION_RATIO = 2;
    private final ConcurrentDistributedMap map;
    private final CacheConfig config;
    private final TargetCapacityEvictor targetCapacityEvictor;
    private volatile int localEvictionRatio = 1;
    private volatile int totalEvictionRatio = 1;

    public TargetCapacityMapSizeListener(ConcurrentDistributedMap map, CacheConfig config) {
        this.map = map;
        this.config = config;
        this.targetCapacityEvictor = new TargetCapacityEvictor(map);
    }

    public void localSizeChanged(int delta) {
        if (delta <= 0 || this.config.getTargetMaxInMemoryCount() <= 0) {
            return;
        }
        int overshoot = this.map.localSize() - this.config.getTargetMaxInMemoryCount();
        if (overshoot <= 0) {
            this.localEvictionRatio = 1;
            return;
        }
        if ((float)overshoot > Math.max(10.0f, 0.01f * (float)this.config.getTargetMaxInMemoryCount())) {
            this.localEvictionRatio = 2;
        }
        int maxEvict = Math.min(delta * this.localEvictionRatio, overshoot);
        this.targetCapacityEvictor.evictLocalElements(maxEvict);
    }

    public void sizeChanged(int delta) {
        if (delta <= 0 || this.config.getTargetMaxTotalCount() <= 0) {
            return;
        }
        int overshoot = this.map.size() - this.config.getTargetMaxTotalCount();
        if (overshoot <= 0) {
            this.totalEvictionRatio = 1;
            return;
        }
        if ((float)overshoot > Math.max(10.0f, 0.01f * (float)this.config.getTargetMaxTotalCount())) {
            this.totalEvictionRatio = 2;
        }
        int maxEvict = Math.min(delta * this.totalEvictionRatio, overshoot);
        this.targetCapacityEvictor.evictOrphanElements(maxEvict);
    }
}

