/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import com.tc.object.bytecode.Clearable;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.bytecode.NotClearable;
import com.tc.object.bytecode.NullManager;
import com.tc.util.Assert;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.terracotta.collections.ConcurrentDistributedMapBackend;
import org.terracotta.collections.ConcurrentDistributedMapDso;
import org.terracotta.collections.FinegrainedLock;
import org.terracotta.collections.LockStrategy;
import org.terracotta.collections.LockType;
import org.terracotta.collections.MapSizeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcurrentDistributedMapDsoArray<K, V>
implements ConcurrentDistributedMapBackend<K, V>,
NotClearable {
    private final List<ConcurrentDistributedMapDso<K, V>> storeList;
    private final int segmentShift;
    private final int segmentMask;
    private transient Random rndm;

    public ConcurrentDistributedMapDsoArray(LockType lockType, LockStrategy<? super K> lockStrategy, int concurrency) {
        int ssize;
        Assert.pre((!(ManagerUtil.getManager() instanceof NullManager) ? 1 : 0) != 0);
        int sshift = 0;
        for (ssize = 1; ssize < concurrency; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.storeList = new ArrayList<ConcurrentDistributedMapDso<K, V>>(ssize);
        if (this.storeList instanceof Clearable) {
            ((Clearable)this.storeList).setEvictionEnabled(false);
        }
        for (int i = 0; i < ssize; ++i) {
            this.storeList.add(i, new ConcurrentDistributedMapDso(lockType, lockStrategy));
        }
        this.onLoad();
    }

    private void onLoad() {
        this.rndm = new Random();
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private int getIndexFromKey(Object key) {
        int hash = ConcurrentDistributedMapDsoArray.hash(key.hashCode());
        return hash >>> this.segmentShift & this.segmentMask;
    }

    private ConcurrentDistributedMapDso<K, V> getMapFromKey(Object key) {
        int index = this.getIndexFromKey(key);
        return this.storeList.get(index);
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllEntriesSnapshot() {
        return new AggregateEntriesSnapshotCollection();
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllLocalEntriesSnapshot() {
        return new AggregateLocalEntriesSnapshotCollection();
    }

    @Override
    public void putNoReturn(K key, V value) {
        this.getMapFromKey(key).putNoReturn(key, value);
    }

    @Override
    public void unlockedPutNoReturn(K key, V value) {
        this.getMapFromKey(key).unlockedPutNoReturn(key, value);
    }

    @Override
    public V unlockedGet(K key) {
        return this.getMapFromKey(key).unlockedGet((Object)key);
    }

    @Override
    public void removeNoReturn(K key) {
        this.getMapFromKey(key).removeNoReturn(key);
    }

    @Override
    public void unlockedRemoveNoReturn(K key) {
        this.getMapFromKey(key).unlockedRemoveNoReturn(key);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.getMapFromKey(key).putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.getMapFromKey(key).remove(key, value);
    }

    @Override
    public V replace(K key, V value) {
        return this.getMapFromKey(key).replace(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.getMapFromKey(key).replace(key, oldValue, newValue);
    }

    @Override
    public void clear() {
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            e.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMapFromKey(key).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            if (!e.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AggregateEntrySet();
    }

    @Override
    public V get(Object key) {
        return this.getMapFromKey(key).get(key);
    }

    @Override
    public V unsafeGet(K key) {
        return this.getMapFromKey(key).unsafeGet(key);
    }

    @Override
    public boolean isEmpty() {
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            if (e.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<K> keySet() {
        return new AggregateKeySet();
    }

    @Override
    public V put(K key, V value) {
        return this.getMapFromKey(key).put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Iterator<Map.Entry<K, V>> i$ = m.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<K, V> element;
            Map.Entry<K, V> entry = element = i$.next();
            this.getMapFromKey(entry.getKey()).put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.getMapFromKey(key).remove(key);
    }

    @Override
    public int size() {
        int size = 0;
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            size += e.size();
        }
        return size;
    }

    @Override
    public int localSize() {
        int localSize = 0;
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            localSize += e.localSize();
        }
        return localSize;
    }

    @Override
    public Collection<V> values() {
        return new AggregatedValuesCollection();
    }

    @Override
    public FinegrainedLock createFinegrainedLock(K key) {
        return this.getMapFromKey(key).createFinegrainedLock(key);
    }

    @Override
    public void lockEntry(K key) {
        this.getMapFromKey(key).lockEntry(key);
    }

    @Override
    public void unlockEntry(K key) {
        this.getMapFromKey(key).unlockEntry(key);
    }

    @Override
    public String getLockIdForKey(K key) {
        return this.getMapFromKey(key).getLockIdForKey(key);
    }

    @Override
    public List<Map<K, ?>> getConstituentMaps() {
        return Collections.unmodifiableList(this.storeList);
    }

    @Override
    public Map.Entry<K, V> getRandomEntry() {
        Map.Entry<K, V> entry;
        ConcurrentDistributedMapDso<K, V> random = this.storeList.get(this.rndm.nextInt(this.storeList.size()));
        if (!random.isEmpty() && (entry = random.getRandomEntry()) != null) {
            return entry;
        }
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            Map.Entry<K, V> entry2;
            if (e.isEmpty() || (entry2 = e.getRandomEntry()) == null) continue;
            return entry2;
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> getRandomLocalEntry() {
        Map.Entry<K, V> entry;
        ConcurrentDistributedMapDso<K, V> random = this.storeList.get(this.rndm.nextInt(this.storeList.size()));
        if (random.localSize() != 0 && (entry = random.getRandomLocalEntry()) != null) {
            return entry;
        }
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            Map.Entry<K, V> entry2;
            if (e.localSize() == 0 || (entry2 = e.getRandomLocalEntry()) == null) continue;
            return entry2;
        }
        return null;
    }

    @Override
    public boolean flush(Object key, Object value) {
        return this.getMapFromKey(key).flush(key, value);
    }

    @Override
    public boolean tryRemove(Object key, long time, TimeUnit unit) {
        return this.getMapFromKey(key).tryRemove(key, time, unit);
    }

    @Override
    public MapSizeListener registerMapSizeListener(MapSizeListener newListener) {
        MapSizeListener old = null;
        for (ConcurrentDistributedMapDso<K, V> e : this.storeList) {
            old = e.registerMapSizeListener(newListener);
        }
        return old;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregateEntriesSnapshotCollection
    extends AbstractCollection<Map.Entry<K, V>> {
        private AggregateEntriesSnapshotCollection() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new AggregateSetIterator<Map.Entry<K, V>>(){

                @Override
                protected Iterator<Map.Entry<K, V>> getNextIterator() {
                    return ((ConcurrentDistributedMapDso)this.listIterator.next()).getAllEntriesSnapshot().iterator();
                }
            };
        }

        @Override
        public int size() {
            return ConcurrentDistributedMapDsoArray.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            ConcurrentDistributedMapDso map = ConcurrentDistributedMapDsoArray.this.getMapFromKey(e.getKey());
            return map.getAllEntriesSnapshot().contains(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregateLocalEntriesSnapshotCollection
    extends AbstractCollection<Map.Entry<K, V>> {
        private AggregateLocalEntriesSnapshotCollection() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new AggregateSetIterator<Map.Entry<K, V>>(){

                @Override
                protected Iterator<Map.Entry<K, V>> getNextIterator() {
                    return ((ConcurrentDistributedMapDso)this.listIterator.next()).getAllLocalEntriesSnapshot().iterator();
                }
            };
        }

        @Override
        public int size() {
            long size = 0L;
            for (ConcurrentDistributedMapDso map : ConcurrentDistributedMapDsoArray.this.storeList) {
                if ((size += (long)map.getAllLocalEntriesSnapshot().size()) <= Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            }
            return (int)size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            ConcurrentDistributedMapDso map = ConcurrentDistributedMapDsoArray.this.getMapFromKey(e.getKey());
            return map.getAllLocalEntriesSnapshot().contains(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AggregateSetIterator<T>
    implements Iterator<T> {
        protected final Iterator<ConcurrentDistributedMapDso<K, V>> listIterator;
        protected Iterator<T> currentIterator;

        protected abstract Iterator<T> getNextIterator();

        public AggregateSetIterator() {
            this.listIterator = ConcurrentDistributedMapDsoArray.this.storeList.iterator();
            while (this.listIterator.hasNext()) {
                this.currentIterator = this.getNextIterator();
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            boolean hasNext = false;
            if (this.currentIterator.hasNext()) {
                hasNext = true;
            } else {
                while (this.listIterator.hasNext()) {
                    this.currentIterator = this.getNextIterator();
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
            }
            return hasNext;
        }

        @Override
        public T next() {
            T item = null;
            if (this.currentIterator == null) {
                return null;
            }
            if (this.currentIterator.hasNext()) {
                item = this.currentIterator.next();
            } else {
                while (this.listIterator.hasNext()) {
                    this.currentIterator = this.getNextIterator();
                    if (!this.currentIterator.hasNext()) continue;
                    item = this.currentIterator.next();
                    break;
                }
            }
            return item;
        }

        @Override
        public void remove() {
            this.currentIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseAggregateSet<T>
    extends AbstractSet<T> {
        private BaseAggregateSet() {
        }

        @Override
        public int size() {
            return ConcurrentDistributedMapDsoArray.this.size();
        }

        @Override
        public void clear() {
            ConcurrentDistributedMapDsoArray.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregatedValuesCollection
    extends AbstractCollection<V> {
        private AggregatedValuesCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new AggregateSetIterator<V>(){

                @Override
                protected Iterator<V> getNextIterator() {
                    return ((ConcurrentDistributedMapDso)this.listIterator.next()).values().iterator();
                }
            };
        }

        @Override
        public int size() {
            return ConcurrentDistributedMapDsoArray.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregateEntrySet
    extends BaseAggregateSet<Map.Entry<K, V>> {
        private AggregateEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new AggregateSetIterator<Map.Entry<K, V>>(){

                @Override
                protected Iterator<Map.Entry<K, V>> getNextIterator() {
                    return ((ConcurrentDistributedMapDso)this.listIterator.next()).entrySet().iterator();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = ConcurrentDistributedMapDsoArray.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = ConcurrentDistributedMapDsoArray.this.get(e.getKey());
            if (value != null && value.equals(e.getValue())) {
                return ConcurrentDistributedMapDsoArray.this.remove(e.getKey()) != null;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregateKeySet
    extends BaseAggregateSet<K> {
        private AggregateKeySet() {
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentDistributedMapDsoArray.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentDistributedMapDsoArray.this.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new AggregateSetIterator<K>(){

                @Override
                protected Iterator<K> getNextIterator() {
                    return ((ConcurrentDistributedMapDso)this.listIterator.next()).keySet().iterator();
                }
            };
        }
    }
}

