/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.collections;

import java.util.concurrent.TimeUnit;

public class FinegrainedLockNoDso implements FinegrainedLock {
  public void lock() {
    // no-op
  }

  public void lock(final LockType lockType) {
    // no-op
  }

  public void unlock() {
    // no-op
  }

  public void unlock(final LockType lockType) {
    // no-op
  }

  public boolean tryLock() {
    return true;
  }

  public boolean tryLock(final LockType lockType) {
    return true;
  }

  public boolean tryLock(final long timeout, final TimeUnit unit) {
    return true;
  }

  public boolean tryLock(final LockType lockType, final long timeout, final TimeUnit unit) {
    return true;
  }

  public boolean isHeldByCurrentThread() {
    return false;
  }

  public boolean isHeldByCurrentThread(final LockType lockType) {
    return false;
  }
}
