/*
 * All content copyright (c) 2003-2008 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.collections;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

interface ConcurrentDistributedMapBackend<K, V> extends ConcurrentMap<K, V>, LockableMap<K> {

  int localSize();
  
  void removeNoReturn(K key);

  void putNoReturn(K key, V value);

  Collection<Entry<K, V>> getAllLocalEntriesSnapshot();

  Collection<Entry<K, V>> getAllEntriesSnapshot();

  V unsafeGet(K key);

  String getLockIdForKey(K key);

  List<Map<K, ?>> getConstituentMaps();

  Map.Entry<K, V> getRandomEntry();

  Map.Entry<K, V> getRandomLocalEntry();

  boolean flush(Object key, Object value);

  boolean tryRemove(Object key, long time, TimeUnit unit);

  MapSizeListener registerMapSizeListener(MapSizeListener newListener);
  
  void unlockedPutNoReturn(K key, V value);

  V unlockedGet(K key);
  
  void unlockedRemoveNoReturn(K key);
}