/*
 * Copyright Terracotta, Inc.
 * Copyright IBM Corp. 2024, 2025
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.terracotta.management.sequence;

/**
 * @author Mathieu Carbou
 */
public interface NodeIdSource {

  NodeIdSource MAC_PID = Defaults.MAC_PID_NODE_ID_SOURCE;
  NodeIdSource BEST = Defaults.BEST_NODE_ID_SOURCE;

  long getNodeId();

  class Fixed implements NodeIdSource {

    private final long nodeId;

    public Fixed(long nodeId) {
      this.nodeId = nodeId;
    }

    @Override
    public long getNodeId() {
      return nodeId;
    }
  }
}
