/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.resource.services.events;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.server.ChunkedOutput;

public abstract class TerracottaEventOutput
extends ChunkedOutput<OutboundEvent> {
    private final Field flushingField;

    public TerracottaEventOutput() {
        super("\n\n".getBytes(Charset.forName("UTF-8")));
        try {
            this.flushingField = ChunkedOutput.class.getDeclaredField("flushing");
            this.flushingField.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        this.switchOffAutoFlushing(true);
    }

    private void switchOffAutoFlushing(boolean flushing) {
        try {
            this.flushingField.set((Object)this, flushing);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public synchronized void flush() throws IOException {
        try {
            this.switchOffAutoFlushing(false);
            super.write(null);
        }
        finally {
            this.switchOffAutoFlushing(true);
        }
    }
}

