/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.resource.services;

import com.terracotta.management.resource.services.utils.UriInfoUtils;
import com.terracotta.management.resource.services.utils.UriUtils;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.AgentEntityV2;
import org.terracotta.management.resource.AgentMetadataEntityV2;
import org.terracotta.management.resource.ResponseEntityV2;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.AgentServiceV2;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/v2/agents")
public final class AgentsResourceServiceImplV2 {
    private static final Logger LOG = LoggerFactory.getLogger(AgentsResourceServiceImplV2.class);
    private final AgentServiceV2 agentService = (AgentServiceV2)ServiceLocator.locate(AgentServiceV2.class);
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);

    @GET
    @Produces(value={"application/json"})
    public ResponseEntityV2<AgentEntityV2> getAgents(@Context UriInfo info) {
        LOG.debug(String.format("Invoking AgentsResourceServiceImplV2.getAgents: %s", UriUtils.maskQueryParams((URI)info.getRequestUri())));
        Set idSet = UriInfoUtils.extractAgentIds((UriInfo)info);
        try {
            return this.agentService.getAgents(idSet);
        }
        catch (ServiceExecutionException see) {
            throw new ResourceRuntimeException("Failed to get agents", (Throwable)see, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public ResponseEntityV2<AgentMetadataEntityV2> getAgentsMetadata(@Context UriInfo info) {
        LOG.debug(String.format("Invoking AgentsResourceServiceImplV2.getAgentsMetadata: %s", UriUtils.maskQueryParams((URI)info.getRequestUri())));
        this.validator.validateSafe(info);
        Set idSet = UriInfoUtils.extractAgentIds((UriInfo)info);
        try {
            return this.agentService.getAgentsMetadata(idSet);
        }
        catch (ServiceExecutionException see) {
            throw new ResourceRuntimeException("Failed to get agents metadata", (Throwable)see, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

