/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.resource.services.events;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.events.EventEntityV2;
import org.terracotta.management.resource.services.events.EventServiceV2;
import org.terracotta.management.resource.services.events.TerracottaEventOutput;

@Path(value="/v2/events")
public class AllEventsResourceServiceImplV2 {
    private static final Logger LOG = LoggerFactory.getLogger(AllEventsResourceServiceImplV2.class);
    private final EventServiceV2 eventService = (EventServiceV2)ServiceLocator.locate(EventServiceV2.class);

    @GET
    @Produces(value={"text/event-stream"})
    public TerracottaEventOutput getServerSentEvents(@Context UriInfo info, @QueryParam(value="localOnly") boolean localOnly) {
        LOG.debug(String.format("Invoking AllEventsResourceServiceImplV2.getServerSentEvents: %s", info.getRequestUri()));
        final TerracottaEventOutput eventOutput = new TerracottaEventOutput();
        this.eventService.registerEventListener(new EventServiceV2.EventListener(){

            public void onEvent(EventEntityV2 eventEntity) {
                OutboundEvent.Builder eventBuilder = new OutboundEvent.Builder();
                eventBuilder.reconnectDelay(100L);
                eventBuilder.mediaType(MediaType.APPLICATION_JSON_TYPE);
                eventBuilder.name(EventEntityV2.class.getSimpleName());
                eventBuilder.data(EventEntityV2.class, (Object)eventEntity);
                OutboundEvent event = eventBuilder.build();
                try {
                    eventOutput.write(event);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Event dispatched: {AgentId: %s, Type: %s, ApiVersion: %s, Representables: %s}", eventEntity.getAgentId(), eventEntity.getType(), eventEntity.getApiVersion(), eventEntity.getRootRepresentables()));
                    }
                }
                catch (Exception e) {
                    AllEventsResourceServiceImplV2.this.eventService.unregisterEventListener((EventServiceV2.EventListener)this);
                    try {
                        eventOutput.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn("Error when closing the event output.", (Throwable)ioe);
                    }
                }
            }

            public void onError(Throwable throwable) {
                LOG.warn("Error when waiting for management events.", throwable);
                AllEventsResourceServiceImplV2.this.eventService.unregisterEventListener((EventServiceV2.EventListener)this);
                try {
                    eventOutput.close();
                }
                catch (IOException ioe) {
                    LOG.warn("Error when closing the event output.", (Throwable)ioe);
                }
            }
        }, localOnly);
        return eventOutput;
    }
}

