/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.OnLoad;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionContext;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.IncludeWrapper;
import org.terracotta.ui.util.SelectionUtil;

public class OnLoadAction
extends Action
implements IMenuCreator {
    ConfigViewPart fPart;
    Action fNoop;
    Action fExecute;
    Action fMethod;
    Action fEdit;

    OnLoadAction(ConfigViewPart part) {
        super("On load", 4);
        this.setMenuCreator(this);
        this.fPart = part;
        this.fNoop = new Action("Do nothing", 8){

            public void run() {
                if (this.isChecked()) {
                    OnLoadAction.this.fPart.setOnLoad(OnLoadAction.this, "");
                }
            }
        };
        this.fExecute = new Action("Execute code", 8){

            public void run() {
                if (this.isChecked()) {
                    OnLoadAction.this.run();
                    OnLoadAction.this.fEdit.run();
                }
            }
        };
        this.fMethod = new Action("Call method", 8){

            public void run() {
                if (this.isChecked()) {
                    OnLoadAction.this.run();
                    OnLoadAction.this.fEdit.run();
                }
            }
        };
        this.fEdit = new Action("Edit..."){

            public void run() {
                IncludeWrapper wrapper = (IncludeWrapper)SelectionUtil.getSingleElement(OnLoadAction.this.getSelection());
                boolean isExecute = OnLoadAction.this.isExecute();
                Shell shell = ActionUtil.findSelectedEditorPart().getSite().getShell();
                OnLoadDialog dialog = new OnLoadDialog(shell, wrapper, isExecute);
                try {
                    if (dialog.open() == 0) {
                        OnLoadAction.this.fPart.setOnLoad(OnLoadAction.this, dialog.getResult());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
    }

    public void run() {
    }

    boolean isNoop() {
        return this.fNoop.isChecked();
    }

    boolean isExecute() {
        return this.fExecute.isChecked();
    }

    boolean isMethod() {
        return this.fMethod.isChecked();
    }

    public void setContext(ActionContext context) {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof IncludeWrapper) {
            IncludeWrapper wrapper = (IncludeWrapper)element;
            this.fNoop.setChecked(!wrapper.isSetOnLoad());
            this.fExecute.setChecked(wrapper.isSetOnLoadExecute());
            this.fMethod.setChecked(wrapper.isSetOnLoadMethod());
            this.fEdit.setEnabled(wrapper.isSetOnLoad());
        }
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        return element instanceof IncludeWrapper;
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void dispose() {
    }

    private void fillMenu(Menu menu) {
        ActionContributionItem item = new ActionContributionItem((IAction)this.fNoop);
        item.fill(menu, -1);
        item = new ActionContributionItem((IAction)this.fExecute);
        item.fill(menu, -1);
        item = new ActionContributionItem((IAction)this.fMethod);
        item.fill(menu, -1);
        new Separator().fill(menu, -1);
        item = new ActionContributionItem((IAction)this.fEdit);
        item.fill(menu, -1);
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }

    class OnLoadDialog
    extends MessageDialog {
        IncludeWrapper fWrapper;
        boolean fIsExecute;
        Text fText;
        String fResult;

        OnLoadDialog(Shell shell, IncludeWrapper wrapper, boolean isExecute) {
            super(shell, "OnLoad: " + wrapper, null, OnLoadAction.this.isExecute() ? "Execute script" : "Call method", 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fWrapper = wrapper;
            this.fIsExecute = isExecute;
        }

        protected Control createCustomArea(Composite parent) {
            int flags = this.fIsExecute ? 514 : 0;
            this.fText = new Text(parent, flags | 0x800);
            GridData gd = new GridData(1808);
            if (this.fIsExecute) {
                gd.heightHint = 4 * this.fText.getLineHeight();
            }
            this.fText.setLayoutData((Object)gd);
            OnLoad onload = this.fWrapper.ensureOnLoad();
            String text = this.fIsExecute ? onload.getExecute() : onload.getMethod();
            this.fText.setText(text == null ? "" : text);
            this.fText.selectAll();
            return this.fText;
        }

        public boolean close() {
            this.fResult = this.fText.getText().trim();
            return super.close();
        }

        String getResult() {
            return this.fResult;
        }
    }
}

