/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.LockLevel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionContext;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.LockWrapper;
import org.terracotta.ui.util.SelectionUtil;

public class LockLevelAction
extends Action
implements IMenuCreator {
    ConfigViewPart fPart;
    Action fRead;
    Action fWrite;
    Action fConcurrent;
    Action fSynchronousWrite;

    LockLevelAction(ConfigViewPart part) {
        super("Lock level", 4);
        this.setMenuCreator(this);
        this.fPart = part;
        this.fRead = new Action("Read", 8){

            public void run() {
                if (this.isChecked()) {
                    LockLevelAction.this.run();
                }
            }
        };
        this.fWrite = new Action("Write", 8){

            public void run() {
                if (this.isChecked()) {
                    LockLevelAction.this.run();
                }
            }
        };
        this.fConcurrent = new Action("Concurrent", 8){

            public void run() {
                if (this.isChecked()) {
                    LockLevelAction.this.run();
                }
            }
        };
        this.fSynchronousWrite = new Action("Synchronous-write", 8){

            public void run() {
                if (this.isChecked()) {
                    LockLevelAction.this.run();
                }
            }
        };
    }

    public void run() {
        this.fPart.setLockLevel(this);
    }

    LockLevel.Enum getLevel() {
        if (this.fRead.isChecked()) {
            return LockLevel.READ;
        }
        if (this.fWrite.isChecked()) {
            return LockLevel.WRITE;
        }
        if (this.fConcurrent.isChecked()) {
            return LockLevel.CONCURRENT;
        }
        if (this.fSynchronousWrite.isChecked()) {
            return LockLevel.SYNCHRONOUS_WRITE;
        }
        return LockLevel.WRITE;
    }

    public void setContext(ActionContext context) {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof LockWrapper) {
            LockWrapper wrapper = (LockWrapper)element;
            LockLevel level = wrapper.getLevel();
            this.fRead.setChecked(level != null && level.enumValue() == LockLevel.READ);
            this.fWrite.setChecked(level == null || level.enumValue() == LockLevel.WRITE);
            this.fConcurrent.setChecked(level != null && level.enumValue() == LockLevel.CONCURRENT);
            this.fSynchronousWrite.setChecked(level != null && level.enumValue() == LockLevel.SYNCHRONOUS_WRITE);
        }
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        return element instanceof LockWrapper;
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void dispose() {
    }

    private void fillMenu(Menu menu) {
        ActionContributionItem item = new ActionContributionItem((IAction)this.fRead);
        item.fill(menu, -1);
        item = new ActionContributionItem((IAction)this.fWrite);
        item.fill(menu, -1);
        item = new ActionContributionItem((IAction)this.fConcurrent);
        item.fill(menu, -1);
        item = new ActionContributionItem((IAction)this.fSynchronousWrite);
        item.fill(menu, -1);
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }
}

