/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.terracotta.dso.views.AutoSynchronizedAction;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.EditLockExpressionAction;
import org.terracotta.dso.views.EditLockNameAction;
import org.terracotta.dso.views.LockLevelAction;

public class LockActionGroup
extends ActionGroup {
    private ConfigViewPart fPart;
    private EditLockExpressionAction fEditExpressionAction;
    private LockLevelAction fLevelAction;
    private AutoSynchronizedAction fAutoSyncAction;
    private EditLockNameAction fEditNameAction;

    LockActionGroup(ConfigViewPart part) {
        this.fPart = part;
        this.makeActions();
    }

    ConfigViewPart getPart() {
        return this.fPart;
    }

    private void makeActions() {
        this.fLevelAction = new LockLevelAction(this.fPart);
        this.fEditExpressionAction = new EditLockExpressionAction(this.fPart);
        this.fAutoSyncAction = new AutoSynchronizedAction(this.fPart);
        this.fEditNameAction = new EditLockNameAction(this.fPart);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.fLevelAction.setContext(context);
        this.fEditExpressionAction.setContext(context);
        this.fAutoSyncAction.setContext(context);
        this.fEditNameAction.setContext(context);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fEditNameAction.canActionBeAdded()) {
            menu.add((IAction)this.fEditNameAction);
        }
        if (this.fEditExpressionAction.canActionBeAdded()) {
            menu.add((IAction)this.fEditExpressionAction);
        }
        if (this.fLevelAction.canActionBeAdded()) {
            menu.add((IAction)this.fLevelAction);
        }
        if (this.fAutoSyncAction.canActionBeAdded()) {
            menu.add((IAction)this.fAutoSyncAction);
        }
    }
}

