/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionContext;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.NamedLockWrapper;
import org.terracotta.ui.util.SelectionUtil;

public class EditLockNameAction
extends Action {
    ConfigViewPart fPart;

    EditLockNameAction(ConfigViewPart part) {
        super("Edit name...");
        this.fPart = part;
    }

    public void run() {
        String initialValue;
        String dialogMessage;
        String title;
        NamedLockWrapper wrapper = (NamedLockWrapper)SelectionUtil.getSingleElement(this.getSelection());
        Shell shell = ActionUtil.findSelectedEditorPart().getSite().getShell();
        InputDialog dialog = new InputDialog(shell, title = "Lock name", dialogMessage = "Specify lock name", initialValue = wrapper.getLockName(), null);
        if (dialog.open() == 0) {
            String lockName = dialog.getValue();
            if (lockName != null && (lockName = lockName.trim()) != null && lockName.length() > 0) {
                this.fPart.setLockName(lockName);
            } else if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)("Remove lock '" + wrapper.getMethodExpression() + "'?"))) {
                this.fPart.removeSelectedItem();
            }
        }
    }

    public void setContext(ActionContext context) {
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        return element instanceof NamedLockWrapper;
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }
}

