/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionContext;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.IncludeWrapper;
import org.terracotta.ui.util.SelectionUtil;

public class EditIncludePatternAction
extends Action {
    ConfigViewPart fPart;

    EditIncludePatternAction(ConfigViewPart part) {
        super("Edit expression...");
        this.fPart = part;
    }

    public void run() {
        String initialValue;
        String dialogMessage;
        String title;
        IncludeWrapper wrapper = (IncludeWrapper)SelectionUtil.getSingleElement(this.getSelection());
        Shell shell = ActionUtil.findSelectedEditorPart().getSite().getShell();
        InputDialog dialog = new InputDialog(shell, title = "Include expression", dialogMessage = "Specify include expression", initialValue = wrapper.toString(), null);
        if (dialog.open() == 0) {
            String expr = dialog.getValue();
            if (expr != null && (expr = expr.trim()) != null && expr.length() > 0) {
                this.fPart.setIncludeExpression(expr);
            } else if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)("Remove include '" + wrapper.getClassExpression() + "'?"))) {
                this.fPart.removeSelectedItem();
            }
        }
    }

    public void setContext(ActionContext context) {
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        return element instanceof IncludeWrapper;
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }
}

