/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.TcConfigDocument;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.views.AutolockWrapper;
import org.terracotta.dso.views.BootClassWrapper;
import org.terracotta.dso.views.ConfigContentProvider;
import org.terracotta.dso.views.ConfigLabelProvider;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.DistributedMethodWrapper;
import org.terracotta.dso.views.ExcludeWrapper;
import org.terracotta.dso.views.IncludeWrapper;
import org.terracotta.dso.views.NamedLockWrapper;
import org.terracotta.dso.views.RootWrapper;
import org.terracotta.dso.views.TransientFieldWrapper;
import org.terracotta.dso.views.TreeRoot;

class ConfigViewer
extends TreeViewer {
    private ConfigViewPart fPart;
    private ConfigContentProvider fContentProvider;

    ConfigViewer(Composite parent, ConfigViewPart part) {
        super(new Tree(parent, 2));
        this.fPart = part;
        this.getControl().setLayoutData((Object)new GridData(1808));
        this.setUseHashlookup(true);
        this.setAutoExpandLevel(-1);
        this.fContentProvider = new ConfigContentProvider();
        this.setContentProvider((IContentProvider)this.fContentProvider);
        this.setLabelProvider((IBaseLabelProvider)new ConfigLabelProvider(this));
        this.clearViewer();
    }

    void setConfig(TcConfigDocument.TcConfig config) {
        if (this.fContentProvider == null) {
            return;
        }
        if (config != null && config != TcPlugin.BAD_CONFIG) {
            this.setInput(this.getTreeRoot(config));
        } else {
            this.clearViewer();
        }
    }

    ConfigViewPart getPart() {
        return this.fPart;
    }

    void setFocus() {
        this.getControl().setFocus();
    }

    boolean isInFocus() {
        return this.getControl().isFocusControl();
    }

    void addKeyListener(KeyListener keyListener) {
        this.getControl().addKeyListener(keyListener);
    }

    private TreeRoot getTreeRoot(TcConfigDocument.TcConfig root) {
        return new TreeRoot(root);
    }

    void initContextMenu(IMenuListener menuListener, IWorkbenchPartSite viewSite) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        viewSite.registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    void refreshRoots() {
        this.refresh(this.fContentProvider.rootsWrapper);
        this.expandToLevel(this.fContentProvider.rootsWrapper, -1);
    }

    void refreshRoot(int index) {
        RootWrapper wrapper;
        if (this.fContentProvider.rootsWrapper != null && (wrapper = this.fContentProvider.rootsWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshDistributedMethods() {
        this.refresh(this.fContentProvider.distributedMethodsWrapper);
        this.expandToLevel(this.fContentProvider.distributedMethodsWrapper, -1);
    }

    void refreshDistributedMethod(int index) {
        DistributedMethodWrapper wrapper;
        if (this.fContentProvider.distributedMethodsWrapper != null && (wrapper = this.fContentProvider.distributedMethodsWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshBootClasses() {
        this.refresh(this.fContentProvider.additionalBootJarClassesWrapper);
        this.expandToLevel(this.fContentProvider.additionalBootJarClassesWrapper, -1);
    }

    void refreshBootClass(int index) {
        BootClassWrapper wrapper;
        if (this.fContentProvider.additionalBootJarClassesWrapper != null && (wrapper = this.fContentProvider.additionalBootJarClassesWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshTransientFields() {
        this.refresh(this.fContentProvider.transientFieldsWrapper);
        this.expandToLevel(this.fContentProvider.transientFieldsWrapper, -1);
    }

    void refreshTransientField(int index) {
        TransientFieldWrapper wrapper;
        if (this.fContentProvider.transientFieldsWrapper != null && (wrapper = this.fContentProvider.transientFieldsWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshNamedLock(int index) {
        NamedLockWrapper wrapper;
        if (this.fContentProvider.namedLocksWrapper != null && (wrapper = this.fContentProvider.namedLocksWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshNamedLocks() {
        if (this.fContentProvider.namedLocksWrapper != null) {
            this.refresh(this.fContentProvider.namedLocksWrapper);
            this.expandToLevel(this.fContentProvider.namedLocksWrapper, -1);
        }
    }

    void refreshAutolock(int index) {
        AutolockWrapper wrapper;
        if (this.fContentProvider.autolocksWrapper != null && (wrapper = this.fContentProvider.autolocksWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshAutolocks() {
        if (this.fContentProvider.autolocksWrapper != null) {
            this.refresh(this.fContentProvider.locksWrapper);
            this.expandToLevel(this.fContentProvider.locksWrapper, -1);
        }
    }

    void refreshIncludeRule(int index) {
        IncludeWrapper wrapper;
        if (this.fContentProvider.includesWrapper != null && (wrapper = this.fContentProvider.includesWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshIncludeRules() {
        if (this.fContentProvider.includesWrapper != null) {
            this.refresh(this.fContentProvider.includesWrapper);
            this.expandToLevel(this.fContentProvider.includesWrapper, -1);
        }
    }

    void refreshExcludeRule(int index) {
        ExcludeWrapper wrapper;
        if (this.fContentProvider.excludesWrapper != null && (wrapper = this.fContentProvider.excludesWrapper.getChildAt(index)) != null) {
            this.refresh(wrapper);
        }
    }

    void refreshExcludeRules() {
        if (this.fContentProvider.excludesWrapper != null) {
            this.refresh(this.fContentProvider.excludesWrapper);
            this.expandToLevel(this.fContentProvider.excludesWrapper, -1);
        }
    }

    void refreshInstrumentationRules() {
        this.refresh(this.fContentProvider.instrumentedClassesWrapper);
        this.expandToLevel(this.fContentProvider.instrumentedClassesWrapper, -1);
    }

    void clearViewer() {
        if (this.fContentProvider == null) {
            return;
        }
        this.setInput(TreeRoot.EMPTY_ROOT);
    }
}

