/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.Root;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;

public class ConfigUI {
    static ISelection convertSelection(ISelection selection) {
        IProject project;
        if (selection.isEmpty()) {
            return selection;
        }
        IJavaProject javaProject = ActionUtil.locateSelectedJavaProject(selection);
        IProject iProject = project = javaProject != null ? javaProject.getProject() : null;
        if (project != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<Object> javaElements = new ArrayList<Object>();
            for (Object element : structuredSelection) {
                if (element instanceof Root) {
                    TcPlugin plugin;
                    ConfigurationHelper configHelper;
                    IField field;
                    String rootField = ((Root)element).getFieldName();
                    if (rootField == null || (field = (configHelper = (plugin = TcPlugin.getDefault()).getConfigurationHelper(project)).getField(rootField)) == null) continue;
                    javaElements.add(field);
                    continue;
                }
                if (!(element instanceof IMember)) continue;
                javaElements.add((IMember)element);
            }
            return new StructuredSelection(javaElements);
        }
        return StructuredSelection.EMPTY;
    }

    public static IEditorPart jumpToMember(IJavaElement element) {
        if (element != null) {
            try {
                IEditorPart editor = EditorUtility.openInEditor((Object)element, (boolean)false);
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)element);
                return editor;
            }
            catch (Exception e) {
                TcPlugin.getDefault().openError("Java element(" + element + ")", e);
            }
        }
        return null;
    }

    public static IEditorPart jumpToRegion(IJavaElement element, IRegion region) {
        if (element != null) {
            try {
                IEditorPart editor = EditorUtility.openInEditor((Object)element, (boolean)false);
                EditorUtility.revealInEditor((IEditorPart)editor, (IRegion)region);
                return editor;
            }
            catch (Exception e) {
                TcPlugin.getDefault().openError("Java element(" + element + ")", e);
            }
        }
        return null;
    }
}

