/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.TcConfigDocument;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.views.AdditionalBootJarClassesWrapper;
import org.terracotta.dso.views.AutolockWrapper;
import org.terracotta.dso.views.AutolocksWrapper;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.DistributedMethodWrapper;
import org.terracotta.dso.views.DistributedMethodsWrapper;
import org.terracotta.dso.views.ExcludeWrapper;
import org.terracotta.dso.views.ExcludesWrapper;
import org.terracotta.dso.views.IncludeWrapper;
import org.terracotta.dso.views.IncludesWrapper;
import org.terracotta.dso.views.NamedLockWrapper;
import org.terracotta.dso.views.NamedLocksWrapper;
import org.terracotta.dso.views.RootWrapper;
import org.terracotta.dso.views.RootsWrapper;
import org.terracotta.dso.views.TransientFieldWrapper;
import org.terracotta.dso.views.TransientFieldsWrapper;
import org.terracotta.ui.util.SelectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigTransferDropAdapter
extends ViewerDropAdapter {
    private ConfigViewPart fPart;
    private List fElements;
    private ISelection fSelection;
    private String fLastDropDescription;

    public ConfigTransferDropAdapter(ConfigViewPart viewPart, StructuredViewer viewer) {
        super((Viewer)viewer);
        this.setSelectionFeedbackEnabled(true);
        this.setFeedbackEnabled(true);
        this.fPart = viewPart;
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.setSelectionFeedbackEnabled(false);
        this.fElements = null;
        this.fSelection = null;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            this.fSelection = StructuredSelection.EMPTY;
            this.fElements = Collections.EMPTY_LIST;
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferData) {
        this.initializeSelection();
        IJavaElement[] inputElements = ConfigTransferDropAdapter.getInputElements(this.getSelection());
        if (inputElements != null && inputElements.length > 0) {
            switch (inputElements[0].getElementType()) {
                case 8: {
                    if (!(target instanceof RootsWrapper) && !(target instanceof RootWrapper) && !(target instanceof TransientFieldsWrapper) && !(target instanceof TransientFieldWrapper)) break;
                    return true;
                }
                case 4: 
                case 11: {
                    if (!(target instanceof AutolocksWrapper) && !(target instanceof AutolockWrapper) && !(target instanceof NamedLocksWrapper) && !(target instanceof NamedLockWrapper) && !(target instanceof IncludesWrapper) && !(target instanceof IncludeWrapper) && !(target instanceof ExcludesWrapper) && !(target instanceof ExcludeWrapper)) break;
                    return true;
                }
                case 9: {
                    if (!(target instanceof DistributedMethodsWrapper) && !(target instanceof DistributedMethodWrapper) && !(target instanceof AutolocksWrapper) && !(target instanceof AutolockWrapper) && !(target instanceof NamedLocksWrapper) && !(target instanceof NamedLockWrapper)) break;
                    return true;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (!(target instanceof AdditionalBootJarClassesWrapper) && !(target instanceof AutolocksWrapper) && !(target instanceof AutolockWrapper) && !(target instanceof NamedLocksWrapper) && !(target instanceof NamedLockWrapper) && !(target instanceof IncludesWrapper) && !(target instanceof IncludeWrapper) && !(target instanceof ExcludesWrapper) && !(target instanceof ExcludeWrapper)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    public void drop(DropTargetEvent event) {
        event.detail = 1;
        super.drop(event);
        event.detail = 0;
    }

    public boolean performDrop(Object data) {
        IProject project = this.fPart.m_javaProject.getProject();
        TcPlugin plugin = TcPlugin.getDefault();
        if (plugin.getConfiguration(project) == TcPlugin.BAD_CONFIG) {
            Shell shell = Display.getDefault().getActiveShell();
            String title = "Terracotta Plugin";
            String msg = "The configuration source is not parsable and cannot be\n used until these errors are resolved.";
            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
            try {
                plugin.openConfigurationEditor(project);
            }
            catch (Exception e) {
                // empty catch block
            }
            return false;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        DropOperation operation = new DropOperation();
        operation.addContext(undoContext);
        try {
            IStatus result = operationHistory.execute((IUndoableOperation)operation, null, null);
            return result == Status.OK_STATUS;
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing DropOperation", ee);
            return false;
        }
    }

    private <E> E[] toArray(List elements, Class<E> filterType) {
        Iterator iter = elements.iterator();
        ArrayList l = new ArrayList();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!filterType.isAssignableFrom(o.getClass())) continue;
            l.add(o);
        }
        return l.toArray((Object[])Array.newInstance(filterType, 0));
    }

    private boolean handleDrop() {
        List list = SelectionUtil.toList(this.getSelection());
        Object target = this.getCurrentTarget();
        IJavaElement element = (IJavaElement)list.get(0);
        switch (element.getElementType()) {
            case 8: {
                if (target instanceof RootsWrapper || target instanceof RootWrapper) {
                    this.fPart.addRoots(this.toArray(list, IField.class));
                    this.fLastDropDescription = "Add Shared Roots";
                    return true;
                }
                if (!(target instanceof TransientFieldsWrapper) && !(target instanceof TransientFieldWrapper)) break;
                this.fPart.addTransientFields(this.toArray(list, IField.class));
                this.fLastDropDescription = "Add Transient Fields";
                return true;
            }
            case 4: 
            case 11: {
                if (target instanceof AutolocksWrapper || target instanceof AutolockWrapper) {
                    this.fPart.addAutolocks(this.toArray(list, IJavaElement.class));
                    this.fLastDropDescription = "Add Autolocks";
                    return true;
                }
                if (target instanceof NamedLocksWrapper || target instanceof NamedLockWrapper) {
                    this.fPart.addNamedLocks(this.toArray(list, IJavaElement.class));
                    this.fLastDropDescription = "Add Named Locks";
                    return true;
                }
                if (target instanceof IncludesWrapper || target instanceof IncludeWrapper) {
                    this.fPart.addIncludes(this.toArray(list, IJavaElement.class));
                    this.fLastDropDescription = "Add Instrumented Types";
                    return true;
                }
                if (!(target instanceof ExcludesWrapper) && !(target instanceof ExcludeWrapper)) break;
                this.fPart.addExcludes(this.toArray(list, IJavaElement.class));
                this.fLastDropDescription = "Add Excluded Types";
                return true;
            }
            case 9: {
                if (target instanceof DistributedMethodsWrapper || target instanceof DistributedMethodWrapper) {
                    this.fPart.addDistributedMethods(this.toArray(list, IMethod.class));
                    this.fLastDropDescription = "Add Distributed Methods";
                    return true;
                }
                if (target instanceof AutolocksWrapper || target instanceof AutolockWrapper) {
                    this.fPart.addAutolocks((IJavaElement[])this.toArray(list, IMethod.class));
                    this.fLastDropDescription = "Add Autolocks";
                    return true;
                }
                if (!(target instanceof NamedLocksWrapper) && !(target instanceof NamedLockWrapper)) break;
                this.fPart.addNamedLocks((IJavaElement[])this.toArray(list, IMethod.class));
                this.fLastDropDescription = "Add Named Locks";
                return true;
            }
            case 6: {
                try {
                    if (target instanceof AdditionalBootJarClassesWrapper) {
                        IType[] types = new IType[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            types[i] = ((IClassFile)list.get(i)).getType();
                        }
                        this.fPart.addAdditionalBootJarClasses(types);
                        this.fLastDropDescription = "Add BootJar Types";
                        return true;
                    }
                    if (target instanceof AutolocksWrapper || target instanceof AutolockWrapper) {
                        this.fPart.addAutolocks(this.toArray(list, IJavaElement.class));
                        this.fLastDropDescription = "Add Autolocks";
                        return true;
                    }
                    if (target instanceof NamedLocksWrapper || target instanceof NamedLockWrapper) {
                        this.fPart.addNamedLocks(this.toArray(list, IJavaElement.class));
                        this.fLastDropDescription = "Add Named Locks";
                        return true;
                    }
                    if (target instanceof IncludesWrapper || target instanceof IncludeWrapper) {
                        this.fPart.addIncludes(this.toArray(list, IJavaElement.class));
                        this.fLastDropDescription = "Add Instrumented Types";
                        return true;
                    }
                    if (target instanceof ExcludesWrapper || target instanceof ExcludeWrapper) {
                        this.fPart.addExcludes(this.toArray(list, IJavaElement.class));
                        this.fLastDropDescription = "Add Excluded Types";
                        return true;
                    }
                }
                catch (Exception e) {}
                break;
            }
            case 5: {
                if (target instanceof AdditionalBootJarClassesWrapper) {
                    IType[] types = new IType[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        types[i] = ((ICompilationUnit)list.get(i)).findPrimaryType();
                    }
                    this.fPart.addAdditionalBootJarClasses(types);
                    this.fLastDropDescription = "Add BootJar Types";
                    return true;
                }
                if (target instanceof AutolocksWrapper || target instanceof AutolockWrapper) {
                    this.fPart.addAutolocks(this.toArray(list, IJavaElement.class));
                    this.fLastDropDescription = "Add Autolocks";
                    return true;
                }
                if (target instanceof NamedLocksWrapper || target instanceof NamedLockWrapper) {
                    this.fPart.addNamedLocks(this.toArray(list, IJavaElement.class));
                    this.fLastDropDescription = "Add Named Locks";
                    return true;
                }
                if (target instanceof IncludesWrapper || target instanceof IncludeWrapper) {
                    this.fPart.addIncludes(this.toArray(list, IJavaElement.class));
                    this.fLastDropDescription = "Add Instrumented Types";
                    return true;
                }
                if (!(target instanceof ExcludesWrapper) && !(target instanceof ExcludeWrapper)) break;
                this.fPart.addExcludes(this.toArray(list, IJavaElement.class));
                this.fLastDropDescription = "Add Excluded Types";
                return true;
            }
            case 7: {
                if (target instanceof AdditionalBootJarClassesWrapper) {
                    this.fPart.addAdditionalBootJarClasses(this.toArray(list, IType.class));
                    this.fLastDropDescription = "Add BootJar Types";
                    return true;
                }
                if (target instanceof AutolocksWrapper || target instanceof AutolockWrapper) {
                    this.fPart.addAutolocks((IJavaElement[])this.toArray(list, IType.class));
                    this.fLastDropDescription = "Add Autolocks";
                    return true;
                }
                if (target instanceof NamedLocksWrapper || target instanceof NamedLockWrapper) {
                    this.fPart.addNamedLocks((IJavaElement[])this.toArray(list, IType.class));
                    this.fLastDropDescription = "Add Named Locks";
                    return true;
                }
                if (target instanceof IncludesWrapper || target instanceof IncludeWrapper) {
                    this.fPart.addIncludes((IJavaElement[])this.toArray(list, IType.class));
                    this.fLastDropDescription = "Add Instrumented Types";
                    return true;
                }
                if (!(target instanceof ExcludesWrapper) && !(target instanceof ExcludeWrapper)) break;
                this.fPart.addExcludes((IJavaElement[])this.toArray(list, IType.class));
                this.fLastDropDescription = "Add Excluded Types";
                return true;
            }
        }
        return false;
    }

    private static IJavaElement[] getInputElements(ISelection selection) {
        List list = SelectionUtil.toList(selection);
        if (list == null) {
            return null;
        }
        return ConfigTransferDropAdapter.getCandidates(list);
    }

    public static IJavaElement[] getCandidates(List input) {
        Iterator iter = input.iterator();
        int type = -1;
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaElement)) {
                return null;
            }
            IJavaElement javaElement = (IJavaElement)element;
            int elementType = javaElement.getElementType();
            if (type == -1) {
                type = elementType;
                continue;
            }
            if (type == elementType) continue;
            return null;
        }
        return input.toArray(new IJavaElement[0]);
    }

    private class DropOperation
    extends AbstractOperation {
        TcConfigDocument.TcConfig fPreConfig;
        TcConfigDocument.TcConfig fPostConfig;

        DropOperation() {
            super("Drop operation");
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            this.fPreConfig = (TcConfigDocument.TcConfig)ConfigTransferDropAdapter.this.fPart.getConfig().copy();
            if (ConfigTransferDropAdapter.this.handleDrop()) {
                this.fPostConfig = (TcConfigDocument.TcConfig)ConfigTransferDropAdapter.this.fPart.getConfig().copy();
                this.setLabel(ConfigTransferDropAdapter.this.fLastDropDescription);
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                this.setConfig(this.fPostConfig);
            }
            catch (Exception e) {
                throw new ExecutionException("Redoing drop operation", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                this.setConfig(this.fPreConfig);
            }
            catch (Exception e) {
                throw new ExecutionException("Undoing drop operation", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private void setConfig(TcConfigDocument.TcConfig config) throws Exception {
            TcPlugin plugin = TcPlugin.getDefault();
            IJavaProject javaProject = ConfigTransferDropAdapter.this.fPart.getJavaProject();
            XmlOptions xmlOpts = plugin.getXmlOptions();
            TcConfigDocument doc = TcConfigDocument.Factory.newInstance((XmlOptions)xmlOpts);
            doc.setTcConfig(config);
            plugin.setConfigurationFromString(javaProject.getProject(), plugin.configDocumentAsString(doc));
        }
    }
}

