/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.Application;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.TcConfigDocument;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.terracotta.dso.views.AdditionalBootJarClassesWrapper;
import org.terracotta.dso.views.AutolocksWrapper;
import org.terracotta.dso.views.DistributedMethodsWrapper;
import org.terracotta.dso.views.ExcludesWrapper;
import org.terracotta.dso.views.IncludesWrapper;
import org.terracotta.dso.views.InstrumentedClassesWrapper;
import org.terracotta.dso.views.LocksWrapper;
import org.terracotta.dso.views.NamedLocksWrapper;
import org.terracotta.dso.views.RootsWrapper;
import org.terracotta.dso.views.TransientFieldsWrapper;
import org.terracotta.dso.views.TreeRoot;

public class ConfigContentProvider
implements ITreeContentProvider {
    RootsWrapper rootsWrapper;
    LocksWrapper locksWrapper;
    AutolocksWrapper autolocksWrapper;
    NamedLocksWrapper namedLocksWrapper;
    TransientFieldsWrapper transientFieldsWrapper;
    InstrumentedClassesWrapper instrumentedClassesWrapper;
    IncludesWrapper includesWrapper;
    ExcludesWrapper excludesWrapper;
    DistributedMethodsWrapper distributedMethodsWrapper;
    AdditionalBootJarClassesWrapper additionalBootJarClassesWrapper;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof RootsWrapper) {
            return ((RootsWrapper)parentElement).createRootWrappers();
        }
        if (parentElement instanceof TransientFieldsWrapper) {
            return ((TransientFieldsWrapper)parentElement).createTransientFieldWrappers();
        }
        if (parentElement instanceof AdditionalBootJarClassesWrapper) {
            return ((AdditionalBootJarClassesWrapper)parentElement).createBootClassWrappers();
        }
        if (parentElement instanceof DistributedMethodsWrapper) {
            return ((DistributedMethodsWrapper)parentElement).createDistributedMethodWrappers();
        }
        if (parentElement instanceof LocksWrapper) {
            LocksWrapper locks = (LocksWrapper)parentElement;
            Object[] objectArray = new Object[2];
            this.autolocksWrapper = new AutolocksWrapper(locks);
            objectArray[0] = this.autolocksWrapper;
            this.namedLocksWrapper = new NamedLocksWrapper(locks);
            objectArray[1] = this.namedLocksWrapper;
            return objectArray;
        }
        if (parentElement instanceof InstrumentedClassesWrapper) {
            InstrumentedClassesWrapper ic = (InstrumentedClassesWrapper)parentElement;
            Object[] objectArray = new Object[2];
            this.includesWrapper = new IncludesWrapper(ic);
            objectArray[0] = this.includesWrapper;
            this.excludesWrapper = new ExcludesWrapper(ic);
            objectArray[1] = this.excludesWrapper;
            return objectArray;
        }
        if (parentElement instanceof AutolocksWrapper) {
            return ((AutolocksWrapper)parentElement).createAutolockWrappers();
        }
        if (parentElement instanceof NamedLocksWrapper) {
            return ((NamedLocksWrapper)parentElement).createNamedLockWrappers();
        }
        if (parentElement instanceof IncludesWrapper) {
            return ((IncludesWrapper)parentElement).createIncludeWrappers();
        }
        if (parentElement instanceof ExcludesWrapper) {
            return ((ExcludesWrapper)parentElement).createExcludeWrappers();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof TreeRoot || element instanceof RootsWrapper && ((RootsWrapper)element).sizeOfRootArray() > 0 || element instanceof LocksWrapper || element instanceof AutolocksWrapper && ((AutolocksWrapper)element).sizeOfAutolockArray() > 0 || element instanceof NamedLocksWrapper && ((NamedLocksWrapper)element).sizeOfNamedLockArray() > 0 || element instanceof InstrumentedClassesWrapper || element instanceof IncludesWrapper && ((IncludesWrapper)element).sizeOfIncludeArray() > 0 || element instanceof ExcludesWrapper && ((ExcludesWrapper)element).sizeOfExcludeArray() > 0 || element instanceof TransientFieldsWrapper && ((TransientFieldsWrapper)element).sizeOfFieldNameArray() > 0 || element instanceof AdditionalBootJarClassesWrapper && ((AdditionalBootJarClassesWrapper)element).sizeOfIncludeArray() > 0 || element instanceof DistributedMethodsWrapper && ((DistributedMethodsWrapper)element).sizeOfMethodExpressionArray() > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == TreeRoot.EMPTY_ROOT) {
            return new Object[0];
        }
        if (inputElement instanceof TreeRoot) {
            DsoApplication dsoApp;
            TcConfigDocument.TcConfig config = ((TreeRoot)inputElement).getRoot();
            if (config == null) {
                return new Object[0];
            }
            Application app = config.getApplication();
            if (app == null) {
                app = config.addNewApplication();
            }
            if ((dsoApp = app.getDso()) == null) {
                dsoApp = app.addNewDso();
            }
            Object[] objectArray = new Object[6];
            this.rootsWrapper = new RootsWrapper(dsoApp);
            objectArray[0] = this.rootsWrapper;
            this.locksWrapper = new LocksWrapper(dsoApp);
            objectArray[1] = this.locksWrapper;
            this.transientFieldsWrapper = new TransientFieldsWrapper(dsoApp);
            objectArray[2] = this.transientFieldsWrapper;
            this.instrumentedClassesWrapper = new InstrumentedClassesWrapper(dsoApp);
            objectArray[3] = this.instrumentedClassesWrapper;
            this.distributedMethodsWrapper = new DistributedMethodsWrapper(dsoApp);
            objectArray[4] = this.distributedMethodsWrapper;
            this.additionalBootJarClassesWrapper = new AdditionalBootJarClassesWrapper(dsoApp);
            objectArray[5] = this.additionalBootJarClassesWrapper;
            return objectArray;
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

