/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;

public class RenameTypeChange
extends Change {
    private String fOldTypeName;
    private String fNewTypeName;
    private String fProjectName;

    public RenameTypeChange(IType type, String newTypeName) {
        this.fOldTypeName = PatternHelper.getFullyQualifiedName(type);
        this.fNewTypeName = StringUtils.replace((String)this.fOldTypeName, (String)type.getElementName(), (String)newTypeName);
        this.fProjectName = type.getAncestor(2).getElementName();
    }

    public RenameTypeChange(String oldTypeName, String newTypeName, String projectName) {
        this.fNewTypeName = newTypeName;
        this.fOldTypeName = oldTypeName;
        this.fProjectName = projectName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return "TCRenameTypeConfigUpdate";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.fProjectName);
        TcPlugin.getDefault().replaceConfigText(project, this.fOldTypeName, this.fNewTypeName);
        return new RenameTypeChange(this.fNewTypeName, this.fOldTypeName, this.fProjectName);
    }
}

