/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.terracotta.dso.TcPlugin;

public class RenamePackageFragmentChange
extends Change {
    private String fOldFragmentName;
    private String fNewFragmentName;
    private String fProjectName;

    public RenamePackageFragmentChange(IPackageFragment fragment, String newName) {
        this.fOldFragmentName = fragment.getElementName();
        this.fNewFragmentName = newName;
        this.fProjectName = fragment.getAncestor(2).getElementName();
    }

    public RenamePackageFragmentChange(String oldTypeName, String newTypeName, String projectName) {
        this.fNewFragmentName = newTypeName;
        this.fOldFragmentName = oldTypeName;
        this.fProjectName = projectName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.fProjectName);
        IFile configFile = TcPlugin.getDefault().getConfigurationFile(project);
        return "Replace '" + this.fOldFragmentName + "' with '" + this.fNewFragmentName + "' in " + configFile.getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.fProjectName);
        TcPlugin.getDefault().replaceConfigText(project, this.fOldFragmentName, this.fNewFragmentName);
        return new RenamePackageFragmentChange(this.fNewFragmentName, this.fOldFragmentName, this.fProjectName);
    }
}

