/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.refactoring.RenameMethodChange;

public class RenameMethodParticipant
extends RenameParticipant {
    private IMethod fMethod;
    private String fDestination;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws OperationCanceledException {
        return RenameMethodParticipant.createChangesForMethodRename(this.fMethod, this.fDestination);
    }

    public String getName() {
        return "TCRenameMethodChange";
    }

    protected boolean initialize(Object element) {
        IMethod method;
        IProject project;
        TcPlugin plugin = TcPlugin.getDefault();
        ConfigurationHelper configHelper = plugin.getConfigurationHelper(project = (method = (IMethod)element).getJavaProject().getProject());
        if (configHelper.isLocked(method) || configHelper.isDistributedMethod(method)) {
            this.fMethod = method;
            this.fDestination = this.getArguments().getNewName();
            return true;
        }
        return false;
    }

    public static Change createChangesForMethodRename(IMethod method, String destination) {
        return new RenameMethodChange(method, destination);
    }
}

