/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;

public class RenameMethodChange
extends Change {
    private String fOldMethodName;
    private String fNewMethodName;
    private String fProjectName;

    public RenameMethodChange(IMethod method, String newMethodName) {
        this.fOldMethodName = PatternHelper.getFullName(method);
        this.fNewMethodName = StringUtils.replace((String)this.fOldMethodName, (String)method.getElementName(), (String)newMethodName);
        this.fProjectName = method.getAncestor(2).getElementName();
    }

    public RenameMethodChange(String oldMethodName, String newMethodName, String projectName) {
        this.fNewMethodName = newMethodName;
        this.fOldMethodName = oldMethodName;
        this.fProjectName = projectName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return "TCRenameMethodConfigUpdate";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.fProjectName);
        TcPlugin.getDefault().replaceConfigText(project, this.fOldMethodName, this.fNewMethodName);
        return new RenameMethodChange(this.fNewMethodName, this.fOldMethodName, this.fProjectName);
    }
}

