/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.terracotta.dso.refactoring.MoveTypeChange;

public class MoveTypeParticipant
extends MoveParticipant {
    private IType fType;
    private IJavaElement fDestination;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws OperationCanceledException {
        return MoveTypeParticipant.createChangesForTypeMove(this.fType, this.fDestination);
    }

    public String getName() {
        return "TCTypeChange";
    }

    protected boolean initialize(Object element) {
        this.fType = (IType)element;
        Object destination = this.getArguments().getDestination();
        if (destination instanceof IPackageFragment || destination instanceof IType) {
            this.fDestination = (IJavaElement)destination;
            return true;
        }
        return false;
    }

    public static Change createChangesForTypeMove(IType type, IJavaElement destination) {
        IJavaProject pdestination = destination.getJavaProject();
        String newpname = null;
        if (!type.getJavaProject().equals(pdestination)) {
            newpname = pdestination.getElementName();
        }
        String newfqname = type.getElementName();
        if (destination instanceof IType) {
            newfqname = ((IType)destination).getFullyQualifiedName() + '$' + type.getElementName();
        } else if (destination instanceof IPackageFragment && !((IPackageFragment)destination).isDefaultPackage()) {
            newfqname = destination.getElementName() + '.' + type.getElementName();
        }
        return new MoveTypeChange(type, newfqname, newpname);
    }
}

